package com.liquidnet.service.kylin.controller.partner;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.CreateTicketTimesParam;
import com.liquidnet.service.kylin.dto.param.PerformanceStep1Param;
import com.liquidnet.service.kylin.dto.vo.TicketTimesVo;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketTimesPartnerServiceImpl;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 场次 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@RestController
@RequestMapping("/partner/times")
public class KylinTicketTimesPartnerController {

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建场次")
    @ApiResponse(response = TicketTimesVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketTimesVo> createTimes(@RequestBody CreateTicketTimesParam createTicketTimesParam) {
        TicketTimesVo result = null;
        result = ticketTimesPartnerService.createTimes(createTicketTimesParam);
        if (null == result) {
            return ResponseDto.failure("创建失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除场次")
    @ApiResponse(response = TicketTimesVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<String> deleteTimes(@RequestParam("ticketTimesId") String ticketTimesId) {
        boolean result = ticketTimesPartnerService.deleteTimes(ticketTimesId);
        if (result) {
            return ResponseDto.success("删除成功");
        } else {
            return ResponseDto.failure("删除失败");
        }
    }

    @PutMapping(value = "")
    @ApiOperation(value = "修改场次")
    @ApiResponse(response = TicketTimesVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketTimesVo> deleteTimes(@RequestBody CreateTicketTimesParam createTicketTimesParam) {
        TicketTimesVo result = null;
        result = ticketTimesPartnerService.changeTimes(createTicketTimesParam);
        if (null == result) {
            return ResponseDto.failure("修改失败");
        } else {
            return ResponseDto.success(result);
        }
    }

}
