package com.liquidnet.service.feign.adam.api.account;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcPushNotifyFunding;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import com.liquidnet.service.bank.currencycloud.entity.BankCcTransaction;
import com.liquidnet.service.feign.adam.constant.FeignAdamConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
@FeignClient(name = FeignAdamConstant.LIQUIDNET_SERVICE_ADAM,
        path = FeignAdamConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignAdamConstant.CONTEXT_API_TRANSACTION)
public interface FeignAdamTransactionClient {

    @RequestMapping(value = "/feign/adam-funding/push_notify_bank_cc_funding", method = RequestMethod.POST)
    ResponseDto pushNotifyBankCcFunding(@RequestBody BankCcTransaction funding);

    @RequestMapping(value = "/feign/adam-conversion/push_notify_bank_cc_conversion", method = RequestMethod.POST)
    ResponseDto pushNotifyBankCcConversion(@RequestBody BankCcConversionDto conversionDto);

    @RequestMapping(value = "/feign/adam-payout/push_notify_bank_cc_payment", method = RequestMethod.POST)
    ResponseDto pushNotifyBankCcPayment(@RequestBody BankCcPayment payment);

}
