package com.liquidnet.service.kylin.controller.partner;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.TicketCreateParam;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.dto.vo.TicketVo;
import com.liquidnet.service.kylin.mapper.KylinTicketsMapper;
import com.liquidnet.service.kylin.service.impl.KylinTicketsServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.FieldsPartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 票 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Api
@RestController
@RequestMapping("/partner/ticket")
public class KylinTicketsPartnerController {

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建票务")
    @ApiResponse(response = TicketVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketVo> createTicket(@RequestBody TicketCreateParam ticketCreateParam) {
        TicketVo result = null;
        result = ticketsPartnerService.createTicket(ticketCreateParam);
        if (null == result) {
            return ResponseDto.failure("创建票务失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @PutMapping(value = "")
    @ApiOperation(value = "修改票务")
    @ApiResponse(response = TicketVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketVo> updateTicket(@RequestBody TicketCreateParam ticketCreateParam) {
        TicketVo result = null;
        result = ticketsPartnerService.updateTicket(ticketCreateParam);
        if (null == result) {
            return ResponseDto.failure("修改票务失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除票务")
    @ApiResponse( code = 200, message = "接口返回对象参数")
    public ResponseDto<String> deleteTicket(@RequestParam("ticketsId") String ticketsId) {
        boolean result = ticketsPartnerService.deleteTicket(ticketsId);
        if (!result) {
            return ResponseDto.failure("删除票务失败");
        } else {
            return ResponseDto.success("删除成功");
        }
    }

    @PostMapping(value = "/copy")
    @ApiOperation(value = "复制票务")
    @ApiResponse(response = TicketVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketVo> copyTicket(@RequestParam("ticketsId") String ticketsId) {
        TicketVo result = null;
        result = ticketsPartnerService.copyTicket(ticketsId);
        if (null == result) {
            return ResponseDto.failure("复制票务失败");
        } else {
            return ResponseDto.success(result);
        }
    }
}
