package com.liquidnet.service.kylin.controller.partner;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PerformanceStep1Param;
import com.liquidnet.service.kylin.service.impl.partner.KylinPerformancesPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api
@RestController
@RequestMapping("/partner/performance")
public class PerformancePartnerController {

    @Autowired
    private KylinPerformancesPartnerServiceImpl performancesPartnerService;

    @PostMapping(value = "step1")
    @ApiOperation(value = "创建演出第一步")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> createStep1(@RequestBody PerformanceStep1Param performanceStep1Param) {
        String result = performancesPartnerService.createStep1(performanceStep1Param);
        if (result.isEmpty()) {
            return ResponseDto.failure("创建失败");
        } else {
            return ResponseDto.success();
        }
    }

}
