package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinNftGoodsSkuListJobVo", description = "NFT商品SKU信息JOB使用")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsSkuListJobVo implements Serializable {

    private static final long serialVersionUID = 6938159791378866727L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 16, value = "是否盲盒[0-否|1-是]")
    private String unbox;

    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;

    @ApiModelProperty(position = 56, value = "是否售罄[0-否|1-是] 服务端判断库存使用")
    private String soldoutStatus;

}
