package com.liquidnet.client.admin.zhengzai.smile.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserVoOrg;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserService;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
@SuppressWarnings("all")
public class SmileUserServiceImpl extends ServiceImpl<SmileUserMapper, SmileUser> implements ISmileUserService {

    @Autowired
    SmileUserMapper smileUserMapper;

    @Override
    public PageInfo<SmileUserVo> userList(SmileUserParam smileUserParam) {
        PageInfo<SmileUserVo> pageInfo;
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(smileUserParam);
            List<SmileUserVo> smileUserVos = smileUserMapper.selectUserList(map).stream().map(smileUser -> {
                SmileUserVo smileUserVo = new SmileUserVo();
                BeanUtils.copyProperties(smileUser, smileUserVo);
                return smileUserVo;
            }).collect(Collectors.toList());
            pageInfo = new PageInfo<SmileUserVo>(smileUserVos);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pageInfo;
    }

    @Override
    public SmileUser getUserById(Long uid) {
        log.info("查询用户id:{}", uid);
        //查询未删除，未通过审核的用户,id=uid
        LambdaQueryWrapper<SmileUser> queryWrapper = Wrappers.lambdaQuery(SmileUser.class);
        queryWrapper.eq(SmileUser::getDelTag, 0);
        queryWrapper.eq(false, SmileUser::getType, 0);
        queryWrapper.eq(SmileUser::getId, uid);
        SmileUser smileUser = smileUserMapper.selectById(queryWrapper);
        log.info("smileUser:{}", smileUser);
        return smileUser;
    }

    @Override
    public int create(SmileUser smileUser) {
        smileUser.setCreatedDate(LocalDateTime.now());
        smileUser.setUpdatedDate(LocalDateTime.now());
        smileUser.setDelTag(0);
        log.info("smileUser:{}", smileUser);
        int id = smileUserMapper.insert(smileUser);
        log.info("return id:{}.", id);
        return id;
    }

    @Override
    public List<SmileUserVoOrg> getUserListByOrgId(Long orgId, Long agentId) {
        //查询根据组织ID查询人员信息
        LambdaQueryWrapper<SmileUser> queryWrapper = Wrappers.lambdaQuery(SmileUser.class);
        queryWrapper.eq(SmileUser::getOrgId, orgId);
        List<SmileUserVoOrg> smileUserVos = smileUserMapper.selectList(queryWrapper).stream().map(smileUser -> {
            SmileUserVoOrg smileUserVo = new SmileUserVoOrg();
            BeanUtils.copyProperties(smileUser, smileUserVo);

            return smileUserVo;
        }).collect(Collectors.toList());
        return smileUserVos;
    }

}