package com.liquidnet.client.admin.zhengzai.sweet.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.sweet.entity.SweetYbActivity;
import lombok.Data;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;

@Data
public class SweetYbActivityExportVo implements Serializable, Cloneable {
    @Excel(name = "活动id", cellType = Excel.ColumnType.STRING)
    private String activityId;
    @Excel(name = "活动名称", cellType = Excel.ColumnType.STRING)
    private String title;
    @Excel(name = "封面图地址", cellType = Excel.ColumnType.STRING)
    private String cover;
    @Excel(name = "活动开始时间", cellType = Excel.ColumnType.STRING)
    private String startTime;
    @Excel(name = "活动结束时间", cellType = Excel.ColumnType.STRING)
    private String endTime;
    @Excel(name = "创建时间", cellType = Excel.ColumnType.STRING)
    private String createdAt;


    private static final SweetYbActivityExportVo obj = new SweetYbActivityExportVo();

    public static SweetYbActivityExportVo getNew() {
        try {
            return (SweetYbActivityExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SweetYbActivityExportVo();
    }

    public SweetYbActivityExportVo copyOrderExportVo(SweetYbActivity source) {
        this.setActivityId(source.getActivityId());
        this.setTitle(source.getTitle());
        this.setCover(source.getCover());
        this.setStartTime(source.getStartTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.setEndTime(source.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.setCreatedAt(source.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return this;
    }

}
