package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.dto.param.SweetYbEnrollParam;
import com.liquidnet.service.sweet.dto.vo.SweetYbActivityVo;
import com.liquidnet.service.sweet.entity.SweetYbEnroll;
import com.liquidnet.service.sweet.mapper.SweetYbEnrollMapper;
import com.liquidnet.service.sweet.service.ISweetYbEnrollService;
import com.liquidnet.service.sweet.utils.ObjectUtil;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * YB报名表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-07-29
 */
@Service
public class SweetYbEnrollServiceImpl implements ISweetYbEnrollService {

    @Autowired
    QueueUtils queueUtils;
    @Autowired
    RedisDataUtils redisDataUtils;

    @Override
    public ResponseDto<Boolean> create(SweetYbEnrollParam param) {
        if (param.getActivityId() == null || param.getActivityId().equals("")) {
            param.setActivityId("0");
        }
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_yb_enroll.insert"));
        sqlsDataA.add(new Object[]{
                IDGenerator.nextSnowId(), StringUtil.isEmpty(param.getContactTell()) ? "" : param.getContactTell(),
                StringUtil.isEmpty(param.getContactWechat()) ? "" : param.getContactWechat(), param.getNickname(), param.getStyle(),
                param.getImgUrl(), param.getAudioUrl(), StringUtil.isEmpty(param.getUniversities()) ? "" : param.getUniversities(),
                StringUtil.isEmpty(param.getCityName()) ? "" : param.getCityName(), param.getActivityId()
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_ANSWER_INSERT.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));

        return ResponseDto.success(true);
    }

    @Override
    public ResponseDto<List<SweetYbActivityVo>> list() {
        List<String> list = redisDataUtils.getSweetYbActivityList();
        List<SweetYbActivityVo> voList = ObjectUtil.sweetYbActivityVoList();
        for (String id : list) {
            SweetYbActivityVo vo = redisDataUtils.getSweetYbActivityVo(id);
            voList.add(vo);
        }
        voList = voList.stream().sorted(Comparator.comparing(SweetYbActivityVo::getEndTime, Comparator.reverseOrder())).collect(Collectors.toList());
        return ResponseDto.success(voList);
    }

}
