package com.liquidnet.service.candy.vo;

import com.liquidnet.service.candy.dto.CandyCouponRuleDto;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CandyCouponVo implements Serializable,Cloneable {

    private static final long serialVersionUID = 4073256621782131606L;

    /* --- --- --- CandyCoupon */
    private String title;//标题
    private String label;//标注
    private String notice;//须知
//    private Integer exclusive;//专享标识[0-常规｜1-会员礼包]
//    private Integer busiType;//业务类别[0-全场｜1-演出｜2-商品｜3-优先购]
    private Integer couType;//券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券]
    private Integer bindType;//[0-用户输入兑换｜1-发放至用户]
    private BigDecimal discount;//折扣
    private BigDecimal valFace;//面值
    private BigDecimal valOver;//满减~满
    private BigDecimal valMinus;//满减~减少
    private String expireAt;//过期时间

    /* --- --- --- CandyUserCoupon */
    private String ucouponId;//券id
    private Integer state;//券状态[1-可用|2-无效｜3-已过期｜5-已使用 |21-不可用]
//    private String bindAt;//激活时间
    private String usedAt;//使用时间
    private String usedFor;//购买内容


    /* --- --- --- CandyCouponRule */
    private List<CandyCouponRulesVo> useRules;

    private static final CandyCouponVo obj = new CandyCouponVo();
    public static CandyCouponVo getNew() {
        try {
            return (CandyCouponVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CandyCouponVo();
    }

}
