package com.liquidnet.common.exception.constant;

import com.liquidnet.common.exception.properties.ErrorCodeProperties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 错误代码
 * @class: LiquidnetServiceException
 * @Package com.liquidnet.common.exception
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/21 10:37
 *
 * SYS001[0001~9999] : 系统占用  SYS0010001
 * SEV001[0001~9999] : 公共业务异常
 * PAY001[0001~9999] : 支付服务
 * ACC001[0001~9999] : 账户服务
 * BAK001[0001~9999] : 三方银行服务
 * TAK001[0001~9999] : JOB任务服务
 * USR001[0001~9999] : 用户服务
 */
public enum ErrorCode implements ServiceErrorCode {

    /**
     * 服务器升级
     * <b>code: 1</b>
     */
    SYS_ERROR_SYS("-3",""),
    /**
     * 服务器更新升级
     *
     * <b>code: 1</b>
     */
    ERROR_SYS_UP("-2",""),
    REDIRECT("-1",""),
    SUCCESS("0",""),
    /**
     * 服务器内部错误
     *
     * <b>code: 1</b>
     */
    ERROR("1",""),
    HTTP_FORBIDDEN("403", ""),
    HTTP_RESOURCE_NOT_FOUND("404", ""),
    /**
     * 登录超时
     */
    LOGIN_TIME_OUT("405","login timed out"),
    HTTP_SYSTEM_ERROR("500", "system error"),

    /**
     * 非法参数
     */
    ILLEGAL_ARGUMENT("400","非法参数"),
    /**
     * 接口异常
     */
    INTERFACE_ERROR("7000",""),
    GLOBALID_ERROR("7001","生成globalId 异常"),
    RESPONSE_ERROE_UNKNOWN("ADAM0000001","System busy, please try again later"),
    RESPONSE_ERROE_SYSTEM("ADAM0000002","System abnormal"),
    RESPONSE_ERROE_BIZ("ADAM0000003","Processing failed"),
    REQUEST_REPEATED_SUBMISSION("7001","Please do not submit again"),


    ;


    ErrorCode(String code) {
        this.code = code;
    }

    ErrorCode(String code,String message) {
        this.code = code;
        this.message = message;
    }

    private String code;
    private String message;

    private static final Map<String, ErrorCode> valueMap;
    static {
        Map<String, ErrorCode> errorMap = new HashMap<String, ErrorCode>();
        for (ErrorCode errorCode : ErrorCode.values()) {
            errorMap.put(errorCode.code, errorCode);
        }
        valueMap = Collections.unmodifiableMap(errorMap);
    }
    public static ErrorCode getErrorCode(String code) {
        return valueMap.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getVal() {
        return ErrorCodeProperties.getValue(this.code);
    }
}
