drop schema if exists ln_adam;
create database ln_adam character set utf8mb4 collate utf8mb4_unicode_ci;
use ln_adam;
-- >>------------------------------------------------------------------------------------
drop table if exists adam_third_party;
create table adam_third_party
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64) default '',
    open_id    varchar(64) comment '第三方ID',
    avatar     varchar(255) comment '第三方头像',
    nickname   varchar(64) comment '第三方昵称',
    platform   varchar(20) comment '平台名称',
    state      tinyint comment '0-INIT,1-NORMAL,2-INVALID',
    created_at datetime,
    updated_at datetime
) engine = InnoDB comment '用户第三方账号信息';
create index idx_adam_third_party_open_id on adam_third_party (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_login;
create table adam_login
(
    mid         int unsigned auto_increment primary key,
    mobile      varchar(16),
    platform    varchar(20) comment '平台名称',
    entrance    varchar(20) comment '入口标记：Wechat、H5、App',
    source      varchar(20) comment '来源终端',
    version     varchar(20) comment '终端版本',
    client_ip   varchar(20),
    client_area varchar(30),
    created_at  datetime
) engine = InnoDB comment '登录记录';
create index idx_adam_login_mobile on adam_login (mobile);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_device_tokens;
create table adam_device_token
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64)  not null,
    #     user_id    varchar(255)                          null,
    android    varchar(255) null,
    ios        varchar(255) null,
    ipad       varchar(255) null,
    is_last    tinyint,
    created_at datetime     not null,
    updated_at datetime
) engine = InnoDB comment 'TOKEN';
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user;
create table adam_user
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64) not null,
    mobile     varchar(16) not null,
    passwd     varchar(64),
    pay_code   varchar(64),
    state      tinyint comment '1-NORMAL,2-INVALID',
    created_at datetime    not null,
    updated_at datetime,
    closed_at  datetime,
    is_real    tinyint comment '是否实名：0-NO,1-YES',
    vip_level  tinyint comment '会员标识/级别'
) ENGINE = InnoDB comment '用户';
create unique index uidx_adam_user_uid on adam_user (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user_info_zz;
create table adam_user_info_zz
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64) not null,
    nick_name  varchar(32) comment '昵称',
    sex        varchar(32) comment '性别',
    birthday   date comment '生日YYYY-MM-DD',
    area       varchar(100) comment '常住地/区域',
    signature  varchar(255) comment '个性签名',
    avatar     varchar(255) comment '头像',
    background varchar(255) comment '背景图',
    qr_code    varchar(255) comment '身份二维码',
    qr_pic     varchar(255) comment '身份二维码',
    tag_music  varchar(500) comment '音乐标签'
) engine = InnoDB comment '正在现场用户信息';
create unique index idx_adam_user_info_zz_uid on adam_user_info_zz (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_real_name;
create table adam_real_name
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64)                not null,
    type       enum ('1','2','3','4','5') not null default '1' comment '1大陆身份证 2港澳通行证 3台胞证 4护照 5军官证',
    name       varchar(20)                not null comment '真实姓名',
    id_card    varchar(30)                not null comment '证件号码',
    state      tinyint                    not null comment '0-INIT,1-NORMAL,2-INVALID',
    created_at datetime                   not null,
    updated_at datetime,
    comment    text
) engine = InnoDB comment '实名信息';
create unique index idx_adam_real_name_uid on adam_real_name (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_enters;
create table adam_enters
(
    mid        int unsigned auto_increment primary key,
    #     `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
    enters_id  varchar(64) not null,
    uid        varchar(64) not null comment '用户id',
    type       tinyint     not null default '1' comment '1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证',
    name       varchar(50) not null default '' comment '入场人名称',
    mobile     varchar(20) not null default '' comment '入场人手机号',
    id_card    varchar(20) not null default '' comment '入场人身份号码，或护照号码',
    is_default boolean     not null default false comment '是否是默认入场人：0-否,1-是，客户第一个入场人默认1',
    #     is_certification enum ('yes','no')          not null default 'no' comment '入场人的身份证号是否认证',
    state      tinyint     not null comment '状态：0-INIT,1-NORMAL,2-INVALID',
    created_at datetime    not null,
    updated_at datetime,
    deleted_at datetime,
    comment    text
) engine = InnoDB comment ='入场人';

create unique index uidx_adam_enters_id on adam_enters (enters_id);
create index idx_adam_enters_uid on adam_enters (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_addresses;
create table adam_addresses
(
    mid        int unsigned auto_increment not null primary key,
    #     `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id关联',
    #     `string_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '用户StringID',
    uid        varchar(64)                 not null,
    name       varchar(255)                not null comment '姓名',
    phone      varchar(255)                not null comment '手机号',
    province   varchar(255)                not null comment '省份',
    city       varchar(255)                not null comment '城市',
    county     varchar(255)                not null comment '区县',
    address    varchar(255)                not null comment '详细地址',
    is_default tinyint                     not null default 0 comment '0-非默认,1-默认',
    created_at datetime                    not null,
    updated_at datetime,
    deleted_at datetime
) engine = InnoDB comment '收货地址';
create index idx_adam_addresses_uid on adam_addresses (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_feedback;
create table adam_feedback
(
    mid           int unsigned auto_increment                                  not null primary key,
    uid           varchar(64)                                                  not null,
    type          enum ('complaints', 'bug', 'order', 'video', 'other')        not null comment '反馈类型',
    comment       varchar(255)                                                 not null comment '反馈内容',
    reply_comment varchar(255)                                                 null comment '回复内容',
    source        varchar(255)                                                 not null comment '来源终端',
    version       varchar(255)                                                 not null comment '终端版本',
    model         varchar(255)                              default ''         not null comment '设备',
    status        enum ('notreply', 'replied', 'processed') default 'notreply' not null comment '状态',
    mobile        varchar(50)                                                  not null comment '手机号',
    admin_id      int                                       default 0          not null comment '处理人',
    admin_name    varchar(255)                              default ''         not null comment '处理人姓名',
    admin_time    datetime                                                     null comment '处理时间',
    created_at    datetime                                                     not null,
    updated_at    datetime
) engine = InnoDB comment '反馈';
-- >>------------------------------------------------------------------------------------
drop table if exists adam_collection;
create table adam_collection
(
    mid           int unsigned auto_increment primary key,
    uid           varchar(64)                                                                                                    not null,
    duration      bigint                                                                                         default 0       null,
    content_id    int unsigned,
    content_title varchar(255),
    content_img   varchar(255),
    type          enum ('VIDEO', 'TICKET', 'SITE', 'ARTIST', 'BAND', 'BRAND', 'STYLE', 'GOODS', 'MUSIC', 'SONG') default 'VIDEO' not null comment '收藏类型，默认视频',
    status        tinyint                                                                                        default 1       not null comment '1正常 2删除',
    created_at    datetime                                                                                                       not null,
    updated_at    datetime
) engine = InnoDB comment '收藏';
create index idx_adam_collection_uid on adam_collection (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_disposed;
create table adam_disposed
(
    mid           int unsigned auto_increment                                                                                    not null primary key,
    uid           varchar(64)                                                                                                    not null,
    #     nickname      varchar(32)                                                                                    default '',
    #     avatar        varchar(255)                                                                                   default '',
    content_id    int unsigned,
    content_title varchar(255),
    content_img   varchar(255),
    type          enum ('VIDEO', 'TICKET', 'SITE', 'ARTIST', 'BAND', 'BRAND', 'STYLE', 'GOODS', 'MUSIC', 'SONG') default 'VIDEO' not null comment '收藏类型，默认视频',
    status        tinyint                                                                                        default 1       not null comment '1正常 2删除',
    created_at    datetime                                                                                                       not null,
    updated_at    datetime
) engine = InnoDB comment '想去';
create index idx_adam_disposed_uid on adam_disposed (uid);
create index idx_adam_disposed_content on adam_disposed (content_id);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member;
create table adam_member
(
    mid              int unsigned auto_increment primary key,
    name             varchar(64),
    title            varchar(100),
    icon             varchar(255),
    avatar           varchar(255),
    price            decimal(8, 2) comment '原价',
    price_fixed      decimal(8, 2) comment '限价',
    start_no         varchar(20) comment '起始会员号',
    type             tinyint comment '会员类型',
    interests_detail text comment '权益详情',
    #     gift_pack_id     varchar(64) comment '礼包ID',
    created_at       datetime,
    updated_at       datetime,
    is_notice        tinyint comment '是否展示须知',
    notice_info      text comment '须知内容',
    notice_title     varchar(255),
    agreement        text
);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_order;
create table adam_member_order
(
    mid         int unsigned auto_increment primary key,
    order_no    varchar(64),
    uid         varchar(64),
    mode        tinyint comment '购买方式：1-buy,2-code',
    price       decimal(8, 2) comment '原价',
    price_paid  decimal(8, 2) comment '实际支付',
    member_name varchar(64),
    member_id   int unsigned,
    state       tinyint comment '订单状态',
    member_no   varchar(20) comment '会员号',
    pay_channel varchar(20) comment '支付渠道',
    pay_no      varchar(64) comment '支付订单',
    payment_at  datetime,
    created_at  datetime,
    updated_at  datetime,
    client_ip   varchar(20),
    source      varchar(20),
    version     varchar(20)
);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user_member;
create table adam_user_member
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64)  not null,
    member_no  int unsigned not null,
    state      tinyint comment '1-NORMAL,2-INVALID',
    expiry_at  date comment '到期日期',
    created_at datetime,
    updated_at datetime
);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_code;
create table adam_member_code
(
    mid          int unsigned auto_increment primary key,
    code         varchar(20) comment '会员码',
    member_id    int unsigned comment '会员ID',
    member_no    varchar(20) comment '预留会员号',
    state        tinyint comment '0-未用,1-已用,2-失效',
    created_at   datetime,
    updated_at   datetime,
    start_at     datetime,
    end_at       datetime,
    use_order_no varchar(64) comment '消费订单号',
    use_uid      varchar(64) comment '消费用户ID',
    use_at       datetime
);
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
