package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamEntersParam;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.service.IAdamEntersService;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;

/**
 * <p>
 * 入场人 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-28
 */
@Api(tags = "入场人")
@Slf4j
@RestController
@RequestMapping("/enters")
public class AdamEntersController {
    @Autowired
    IAdamEntersService adamEntersService;
    @Autowired
    AmqpTemplate amqpTemplate;

    @ApiOperationSupport(order = 0)
    @ApiOperation(value = "Producer")
    @PostMapping("producer")
    public ResponseDto<Object> producer() {
        try {
            amqpTemplate.convertAndSend("queue_test", "queue_key", "select * from x " + System.currentTimeMillis());
        } catch (AmqpException e) {
            e.printStackTrace();
        }
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "入场人列表")
    @PostMapping("list")
    public ResponseDto<AdamEntersVo> list() {
        // TODO: 2021/4/29 获取登录用户ID
        String uid = "1";




        return null;
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "添加入场人")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamEntersParam parameter) {
        // TODO: 2021/4/28 数据校验，身份认证


        AdamEnters addInfo = new AdamEnters();
        BeanUtils.copyProperties(parameter, addInfo);
        addInfo.setEntersId(String.valueOf(IDGenerator.nextSnowId()));
        addInfo.setCreatedAt(LocalDateTime.now());
        addInfo.setState(1);


        return adamEntersService.add(addInfo) ? ResponseDto.success() : ResponseDto.failure();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "入场人详情")
    @PostMapping("query/{id}")
    public ResponseDto<Object> query(@PathVariable(name = "id") String entersId) {
        // TODO: 2021/4/28 校验

        return ResponseDto.success(adamEntersService.query(entersId));
    }
}
