package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.mapper.AdamEntersMapper;
import com.liquidnet.service.adam.service.IAdamEntersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 入场人 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-28
 */
@Service
public class AdamEntersServiceImpl extends ServiceImpl<AdamEntersMapper, AdamEnters> implements IAdamEntersService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public List<AdamEntersVo> list(String uid) {
        List<AdamEntersVo> voList = null;

        voList = (List<AdamEntersVo>) redisUtil.hget(AdamRedisConst.INFO_ENTERS, uid);

//        mongoTemplate.find(Query.query(Criteria.where()))

        return voList;
    }

    @Override
    public boolean add(AdamEnters info) {
        // TODO: 2021/4/28 同步REDIS


        Collection<AdamEnters> insertRst = mongoTemplate.insert(Collections.singletonList(info), AdamEnters.class.getSimpleName());

        // TODO: 2021/4/28 放入MQ


        return true;
    }

    @Override
    public AdamEnters query(String entersId) {
        AdamEnters info = null;

        // TODO: 2021/4/28 REDIS:QUERY


        info = mongoTemplate.findOne(Query.query(Criteria.where("entersId").is(entersId)), AdamEnters.class, AdamEnters.class.getSimpleName());

        return info;
    }
}
