package com.liquidnet.service.slime.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.slime.entity.SlimeAuthorizationRecords;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "SlimeAuthorizationRecordsVo", description = "授权记录")
@Data
public class SlimeAuthorizationRecordsVo implements java.io.Serializable, Cloneable{
    private static final long serialVersionUID = 5851793907387626205L;

    @ApiModelProperty(value = "authorization_record_id")
    private String authorizationRecordId;

    @ApiModelProperty(value = "演出ID")
    private String performanceId;

    @ApiModelProperty(value = "权利人演出角色 creator|sponsor|fielder|checker")
    private String uidRole;

    @ApiModelProperty(value = "权利人")
    private String uid;

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "授权人演出角色 creator|sponsor|fielder")
    private String cuidRole;

    @ApiModelProperty(value = "授权人")
    private String cuid;

    @ApiModelProperty(value = "授权的权限")
    private List<SlimeAuthorizationPermissionsVo> permissionsVos;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime deletedAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final SlimeAuthorizationRecordsVo obj = new SlimeAuthorizationRecordsVo();

    public static SlimeAuthorizationRecordsVo getNew() {
        try {
            return (SlimeAuthorizationRecordsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SlimeAuthorizationRecordsVo();
    }

    public SlimeAuthorizationRecordsVo copy(SlimeAuthorizationRecords source) {
        if (null == source) return this;

        this.setAuthorizationRecordId(source.getAuthorizationRecordId());
        this.setPerformanceId(source.getPerformanceId());
        this.setUidRole(source.getUidRole());
        this.setUid(source.getUid());
        this.setMobile(source.getMobile());
        this.setName(source.getName());

        this.setCuid(source.getCuidRole());
        this.setCuid(source.getCuid());

        this.setDeletedAt(source.getDeletedAt());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());

        return this;
    }
}
