package com.liquidnet.service.dragon.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 支付订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DragonOrders implements Serializable, Cloneable {

    private static final long serialVersionUID = -4897000205961106873L;
    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * order_id
     */
    private String orderId;

    /**
     * 订单状态(0未支付 1支付成功 2支付失败)
     */
    private Integer status;

    /**
     * 订单支付编号
     */
    private String code;

    /**
     * 订单类型
     */
    private String type;

    /**
     * 总价格
     */
    private BigDecimal price;

    /**
     * 类别或名称
     */
    private String name;

    /**
     * 详情或描述
     */
    private String detail;

    /**
     * 调用端订单编号
     */
    private String orderCode;

    /**
     * 用户客户端ip地址
     */
    private String clientIp;

    /**
     * 支付完成通知回调地址
     */
    private String notifyUrl;

    /**
     * 通知状态(0初始化 1通知成功 2 通知失败 3通知超时)
     */
    private Integer notifyStatus;

    /**
     * 支付类型
     */
    private String paymentType;

    /**
     * 支付的订单号
     */
    private String paymentId;

    /**
     * 支付时间
     */
    private LocalDateTime paymentAt;

    /**
     * 结束时间
     */
    private LocalDateTime finishedAt;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 删除时间
     */
    private LocalDateTime deletedAt;

    private static final DragonOrders obj = new DragonOrders();

    public static DragonOrders getNew() {
        try {
            return (DragonOrders) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new DragonOrders();
        }
    }


}
