package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.service.IAdamMemberService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "会员信息")
@Slf4j
@RestController
@RequestMapping("/member")
public class AdamMemberController {

    @Autowired
    IAdamMemberService adamMemberService;
    @Autowired
    AmqpTemplate amqpTemplate;

    @ApiOperationSupport(order = 0)
    @ApiOperation(value = "会员信息")
    @GetMapping("info")
    public ResponseDto<Object> query(@PathVariable(name = "id") Integer memberId) {

        AdamMember info = adamMemberService.query(memberId);

        return ResponseDto.success(info);
    }

}
