package com.liquidnet.service.adam.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.service.IAdamMemberService;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AdamMemberServiceImpl extends ServiceImpl<AdamMemberMapper, AdamMember> implements IAdamMemberService {

    @Autowired
    AdamMemberMapper adamMemberMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public List<AdamMember> list() {
        List<AdamMember> infoList = new ArrayList<>();
        List<Object> list = redisUtil.lGet(AdamRedisConst.INFO_MEMBERS, 0, -1);

        if (CollectionUtils.isEmpty(list)) {
            infoList = mongoTemplate.findAll(AdamMember.class);
        } else {
            for (Object o : list) {
                infoList.add((AdamMember) o);
            }
        }
        return infoList;
    }

    @Override
    public void add(AdamMember info) {
        mongoTemplate.insert(Collections.singletonList(info), AdamMember.class.getSimpleName());

        // todo 放入MQ

        // todo 同步redis
        redisUtil.lSet(AdamRedisConst.INFO_MEMBERS, info);
        redisUtil.hmset(AdamRedisConst.INFO_MEMBERS_INFO.concat(info.getMid().toString()), (Map<String, Object>) info);
    }

    @Override
    public AdamMember query(Integer mid) {
        AdamMember info = null;
        info = (AdamMember) redisUtil.hmget(AdamRedisConst.INFO_MEMBERS_INFO.concat(mid.toString()));
        if (null == info) {
            info = mongoTemplate.findOne(Query.query(Criteria.where("mId").is(mid)), AdamMember.class, AdamMember.class.getSimpleName());
        }
        return info;
    }

    @Override
    public void edit(AdamMember info) {
        BasicDBObject object = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(info)));

        mongoTemplate.getCollection(AdamMember.class.getSimpleName())
                .updateOne(Query.query(Criteria.where("mId").is(info.getMid())).getQueryObject(), object);

        // todo 放入MQ
        redisUtil.hset(AdamRedisConst.INFO_MEMBERS_INFO.concat(info.getMid().toString()), info.getMid().toString(), info);
        redisUtil.lRemove(AdamRedisConst.INFO_MEMBERS, 1, info);
        redisUtil.lSet(AdamRedisConst.INFO_MEMBERS, info);
    }
}
