package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class CreateTicketTimesParam implements Serializable {

    @ApiModelProperty(value = "场次Id", example = "")
    private String ticketTimesId;

    @ApiModelProperty(value = "演出Id", example = "1")
    private String PerformancesId;

    @ApiModelProperty(value = "场次标题", example = "测试标题")
    @JsonIgnore
    private String title;

    @ApiModelProperty(value = "场次适用开始时间", example = "2020-12-01T12:00:00")
    private LocalDateTime timeStart;

    @ApiModelProperty(value = "场次适用结束时间", example = "2020-12-01T12:00:00")
    private LocalDateTime timeEnd;

    @ApiModelProperty(value = "类型 1单日票 2通票", example = "1")
    private int type;

    @ApiModelProperty(value = "", example = "")
    @JsonIgnore
    private String createdAt;
}
