package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.adam.api.FeignAdamBaseClient;
import com.liquidnet.service.kylin.utils.DataUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

@Api(tags = "内部接口")
@RestController
@RequestMapping("inner")
@Slf4j
public class InnerController {
    @Autowired
    DataUtils dataUtils;
    @Autowired
    FeignAdamBaseClient adamBaseClient;

    @PostMapping("cache/member")
    @ApiOperation("获取会员相关数据")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "会员id"),
    })
    public void cacheMember(@RequestParam("uid") String uid) {
        try {
            ResponseDto<AdamUserMemberVo> memberVo = adamBaseClient.queryMember(uid);
            AdamUserMemberVo userMemberVo = memberVo.getData();
            if (userMemberVo.getState() == 1) {
                long second = ChronoUnit.SECONDS.between(LocalDateTime.now(), userMemberVo.getExpiryAt());
                if (userMemberVo.isOldMember()) {
                    dataUtils.saveMember(uid, 2, second);
                } else {
                    dataUtils.saveMember(uid, 1, second);
                }
            } else {
                dataUtils.delMember(uid);
            }
        } catch (Exception e) {
            log.error("会员信息error", e);
        }
    }

}
