package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.service.IGalaxyTradeService;
import com.liquidnet.service.galaxy.utils.QueueUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT购买
 * @class: GalaxyNftTradeController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 18:08
 */
@Api(tags = "NFT交易相关")
@RestController
@RequestMapping("nftTrade")
@Validated
@Slf4j
public class GalaxyTradeController {
    @Autowired
    private QueueUtil queueUtil;

    @Resource(name = "galaxyTradeServiceImpl")
    private IGalaxyTradeService galaxyTradeService;

//    @ControllerLog(description = "NFT购买")
//    @ApiOperationSupport(order = 1)
//    @ApiOperation(value = "NFT购买")
//    @PostMapping(value = {"nftBuy"})
//    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(@Valid @RequestBody GalaxyNftBuyReqDto reqDto){
//        return galaxyTradeService.nftBuy(reqDto);
//    }
//
//    @ControllerLog(description = "NFT购买结果查询")
//    @ApiOperationSupport(order = 1)
//    @ApiOperation(value = "NFT购买结果查询")
//    @PostMapping(value = {"nftBuyResultQuery"})
//    public ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(@Valid @RequestBody GalaxyNftBuyResultQueryReqDto reqDto){
//        return galaxyTradeService.nftBuyResultQuery(reqDto);
//    }

    @ControllerLog(description = "NFT购买(发行+购买)")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT购买(发行+购买)")
    @PostMapping(value = {"/que/nftPublishAndBuy"})
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(@Valid @RequestBody GalaxyNftPublishAndBuyReqDto reqDto){
        return galaxyTradeService.nftPublishAndBuy(reqDto);
    }

    @ControllerLog(description = "NFT发行购买结果查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT发行购买结果查询")
    @PostMapping(value = {"nftPublishAndBuyResultQuery"})
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(@Valid @RequestBody GalaxyNftPublishAndBuyResultQueryReqDto reqDto){
        return galaxyTradeService.nftPublishAndBuyResultQuery(reqDto);
    }

    @ControllerLog(description = "NFT转让")
    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "NFT转让")
    @PostMapping(value = {"/que/nftTransfer"})
    public ResponseDto<GalaxyNftTransferRespDto> nftTransfer(@Valid @RequestBody GalaxyNftTransferReqDto reqDto){
        ResponseDto<GalaxyNftTransferRespDto> responseDto = galaxyTradeService.nftTransfer(reqDto);
        if(!responseDto.isSuccess()){
            //系统异常允许重试
            if(responseDto.getCode().equalsIgnoreCase(GalaxyErrorEnum.NFT_TRANSFER_ERROR.getCode())){
                queueUtil.sendMsgByRedis(MQConst.GalaxyQueue.JSON_NFT_TRANSFER.getKey(), JsonUtils.toJson(reqDto));
            }
        }
        return ResponseDto.success();
    }

    @ControllerLog(description = "NFT转让结果查询")
    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "NFT转让结果查询")
    @PostMapping(value = {"nftTransferResultQuery"})
    public ResponseDto<GalaxyNftTransferQueryRespDto> nftTransferResultQuery(@Valid @RequestBody GalaxyNftTransferQueryReqDto reqDto){
        return galaxyTradeService.nftTransferQuery(reqDto);
    }

    @ControllerLog(description = "NFT手工转让调试")
    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "NFT手工转让调试")
    @PostMapping(value = {"/manual/nftTransfer"})
    public ResponseDto<GalaxyNftTransferRespDto> nftManualTransfer(@Valid @RequestBody GalaxyNftTransferReqDto reqDto){
        return galaxyTradeService.nftTransfer(reqDto);
    }

//    @ControllerLog(description = "NFT发行购买结果批量查询")
//    @ApiOperationSupport(order = 1)
//    @ApiOperation(value = "NFT发行购买结果批量查询")
//    @PostMapping(value = {"nftPublishAndBuyResultBatchQuery"})
//    public ResponseDto<GalaxyNftPublishAndBuyResultBatchQueryRespDto> nftPublishAndBuyResultBatchQuery(@Valid @RequestBody GalaxyNftPublishAndBuyResultBatchQueryReqDto reqDto){
//        //定义返回结果
//        List<GalaxyNftPublishAndBuyResultQueryRespDto> routerBuyInfoList = new ArrayList<>();
//        //获取请求信息
//        List<GalaxyNftPublishAndBuyResultBatchQueryReqDto.RouterOrderInfo> routerOrderInfoList = reqDto.getRouterOrderInfoList();
//        routerOrderInfoList.forEach(routerOrderInfo -> {
//            GalaxyNftPublishAndBuyRouterBatchQueryReqDto batchQueryReqDto =  GalaxyNftPublishAndBuyRouterBatchQueryReqDto.getNew();
//            batchQueryReqDto.setUserId(routerOrderInfo.getUserId());
//            batchQueryReqDto.setRouterType(routerOrderInfo.getRouterType());
//            batchQueryReqDto.setNftOrderPayIdList(routerOrderInfo.getNftOrderPayIdList());
//            //进行批量查询
//            ResponseDto<GalaxyNftPublishAndBuyRouterBatchQueryRespDto> responseDtoTemp = galaxyTradeService.nftPublishAndBuyResultBatchQuery(batchQueryReqDto);
//            if(StringUtil.isNotNull(responseDtoTemp)&&responseDtoTemp.isSuccess()){
//                routerBuyInfoList.addAll(responseDtoTemp.getData().getBuyInfoList());
//            }
//        });
//        GalaxyNftPublishAndBuyResultBatchQueryRespDto respDto = GalaxyNftPublishAndBuyResultBatchQueryRespDto.getNew();
//        respDto.setRouterBuyInfoList(routerBuyInfoList);
//        return ResponseDto.success(respDto);
//    }

//    @ControllerLog(description = "NFT购买支付结果查询")
//    @ApiOperationSupport(order = 1)
//    @ApiOperation(value = "NFT购买支付结果查询")
//    @PostMapping(value = {"nftBuyPayResultQuery"})
//    public ResponseDto<GalaxyNftBuyPayResultQueryRespDto> nftBuyPayResultQuery(@Valid @RequestBody GalaxyNftBuyPayResultQueryReqDto reqDto){
//        return galaxyTradeService.nftBuyPayResultQuery(reqDto);
//    }
}
