package com.liquidnet.service.sweet.controller.five;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualFiveDto;
import com.liquidnet.service.sweet.service.five.ISweetManualFiveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Api(tags = "电子手册_Five")
@RestController
@RequestMapping("/Five/sweet-manual")
public class SweetManualFiveController {
    @Autowired
    private ISweetManualFiveService sweetManualFiveService;

    @GetMapping("list")
    @ApiOperation("宣传手册列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "姓名", required = false),
    })
    public ResponseDto<PageInfo<SweetManualFiveDto>> getList(@RequestParam() Integer page,
                                                             @RequestParam() Integer size,
                                                             @RequestParam(required = false) String name) {
        return sweetManualFiveService.getManualList(page, size, name);
    }


    @GetMapping("details")
    @ApiOperation("宣传手册详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id"),
    })
    public ResponseDto<SweetManualFiveDto> details(@RequestParam(required = false) String manualId) {
        return sweetManualFiveService.details(manualId);
    }

    @PostMapping("changeRelease")
    @ApiOperation("修改是否发布")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
    })
    public ResponseDto<Boolean> changeRelease(@RequestParam() String manualId,
                                              @RequestParam() Integer isRelease) {
        return sweetManualFiveService.changeRelease(manualId, isRelease);
    }

    @PostMapping("changeStatus")
    @ApiOperation("修改是否开启")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "status", value = "开启状态", required = true),
    })
    public ResponseDto<Boolean> changeStatus(@RequestParam() String manualId,
                                             @RequestParam() String performancesId,
                                             @RequestParam() Integer status) {
        return sweetManualFiveService.changeStatus(manualId, performancesId, status);
    }
}
