package com.liquidnet.service.galaxy.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserRegisterReqDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/10 20:46
 */
@ApiModel(value = "GalaxyUserRegisterReqDto", description = "用户实名注册")
@Data
public class GalaxyUserRegisterReqDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    @NotBlank(message = "用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String userId;

    @ApiModelProperty(position = 2, required = true, value = "姓名[50]", example = "张三")
    @Size(min = 1, max = 30, message = "姓名长度限制1-30位")
    private String userName;

    @ApiModelProperty(position = 3, required = true, value = "手机号[11]", example = "13111111111")
    @Pattern(regexp = "\\d{11}", message = "手机号格式有误")
    @NotBlank(message = "手机号不能为空")
    @Size(min = 1, max = 11, message = "手机号长度限制1-11位")
    private String mobile;

    @ApiModelProperty(position = 4, required = true, value = "证件类型",example = "")
    @NotBlank(message = "证件类型不能为空！")
    @Size(min = 1, max = 2, message = "证件类型")
    private String idCardType;

    @ApiModelProperty(position = 5, required = true, value = "证件号")
    @NotBlank(message = "证件号不能为空！")
    @Size(min = 1, max = 18, message = "证件号限制1-18位且不能包含特殊字符")
    private String idCard;


    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyUserRegisterReqDto obj = new GalaxyUserRegisterReqDto();

    public static GalaxyUserRegisterReqDto getNew() {
        try {
            return (GalaxyUserRegisterReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyUserRegisterReqDto();
        }
    }
}
