package com.liquidnet.service.galaxy.router.strategy;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyContext
 * @Package com.liquidnet.service.galaxy.router.strategy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/8 11:26
 */
@Component
public class GalaxyRouterStrategyContext {
    private final Map<String, IGalaxyRouterStrategy> handlerMap = new HashMap<>();

    public IGalaxyRouterStrategy getStrategy(String type) {
        return handlerMap.get(type);
    }

    public void putStrategy(String code, IGalaxyRouterStrategy strategy) {
        handlerMap.put(code, strategy);
    }
}
