package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.service.kylin.dto.vo.KylinApiCameraDevicesVo;
import com.liquidnet.service.kylin.service.IKylinCameraService;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 人流量排队检测摄像头表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-10
 */
@Service
public class KylinCameraServiceImpl implements IKylinCameraService {

    @Autowired
    private DataUtils dataUtils;

    @Override
    public List<KylinApiCameraDevicesVo> cameraList(String fieldId, Integer siteType) {
        List<KylinApiCameraDevicesVo> list = dataUtils.getCameraDevices(fieldId);
        ArrayList<KylinApiCameraDevicesVo> devicesVoArrayList = ObjectUtil.getKylinApiCameraDevicesVoArrayList();
        for (KylinApiCameraDevicesVo devicesVo : list) {
            devicesVo.setPersonNum(dataUtils.getCameraDevicePersonNum(devicesVo.getCameraId()));
            if (siteType > 0 && devicesVo.getSiteType() == siteType) {
                devicesVoArrayList.add(devicesVo);
            }
        }
        if (siteType > 0) {
            return devicesVoArrayList;
        } else {
            return list;
        }
    }
}
