package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberPriceAdminService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.admin.AdamMemberPriceBuildParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class AdamMemberPriceAdminServiceImpl extends ServiceImpl<AdamMemberPriceMapper, AdamMemberPrice> implements IAdamMemberPriceAdminService {
    @Autowired
    private AdamMemberPriceMapper adamMemberPriceMapper;
    @Autowired
    private AdamMemberMapper adamMemberMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

//    public AdamMemberPriceVo add(AdamMemberPrice info) {
//        List<AdamMemberPrice> existList = adamMemberPriceMapper.selectList(
//                Wrappers.lambdaQuery(AdamMemberPrice.class).eq(AdamMemberPrice::getMemberId, info.getMemberId()));
//        info.setMemberPriceId(CollectionUtils.isEmpty(existList) ? "101" : IDGenerator.nextSnowId().toString());
//        info.setCreatedAt(LocalDateTime.now());
//
//        adamMemberPriceMapper.insert(info);
//
//        AdamMemberPriceVo vo = AdamMemberPriceVo.getNew().copy(info);
//
//        redisDataSourceUtil.getRedisAdamUtil().set(AdamRedisConst.INFO_MEMBER_PRICE.concat(vo.getMemberPriceId()), vo);
//
//        return vo;
//    }

    @Override
    @Transactional
    public boolean edit(AdamMemberPriceBuildParam param) {
        String memberId = param.getMemberId();

        AdamMember updateInfo = new AdamMember();
        updateInfo.setIntegralRate(param.getIntegralRate());
        LambdaUpdateWrapper<AdamMember> memberLambdaUpdateWrapper = Wrappers.lambdaUpdate(AdamMember.class);
        memberLambdaUpdateWrapper.eq(AdamMember::getState, 1);
        memberLambdaUpdateWrapper.eq(AdamMember::getMemberId, param.getMemberId());
        if (adamMemberMapper.update(updateInfo, memberLambdaUpdateWrapper) > 0) {
            LambdaQueryWrapper<AdamMemberPrice> memberPriceLambdaQueryWrapper = Wrappers.lambdaQuery(AdamMemberPrice.class);
//            memberPriceLambdaQueryWrapper.eq(AdamMemberPrice::getMemberPriceId, memberPriceId);
            memberPriceLambdaQueryWrapper.eq(AdamMemberPrice::getMemberId, memberId);
            memberPriceLambdaQueryWrapper.eq(AdamMemberPrice::getState, 1);
            List<AdamMemberPrice> memberPriceList = adamMemberPriceMapper.selectList(memberPriceLambdaQueryWrapper);
            LocalDateTime nowTime = LocalDateTime.now();
            boolean saveOrUpdateRst;
            AdamMemberPrice saveOrUpdateInfo;
            if (CollectionUtils.isEmpty(memberPriceList)) {
                saveOrUpdateInfo = new AdamMemberPrice();
                saveOrUpdateInfo.setMemberPriceId(memberId + "01");
                saveOrUpdateInfo.setMemberId(memberId);
                saveOrUpdateInfo.setState(1);
                //saveOrUpdateInfo.setName();
                saveOrUpdateInfo.setPrice(param.getPrice());
                saveOrUpdateInfo.setPriceFixed(param.getPriceFixed());
                saveOrUpdateInfo.setPriceSpecial(param.getPriceSpecial());
                saveOrUpdateInfo.setDays(param.getDays());
                //saveOrUpdateInfo.setDetail();
                saveOrUpdateInfo.setCreatedAt(nowTime);

                saveOrUpdateRst = adamMemberPriceMapper.insert(saveOrUpdateInfo) > 0;
            } else {
                saveOrUpdateInfo = new AdamMemberPrice();
                saveOrUpdateInfo.setUpdatedAt(nowTime);

                saveOrUpdateInfo.setPrice(param.getPrice());
                saveOrUpdateInfo.setPriceFixed(param.getPriceFixed());
                saveOrUpdateInfo.setPriceSpecial(param.getPriceSpecial());
                saveOrUpdateInfo.setDays(param.getDays());

                saveOrUpdateRst = adamMemberPriceMapper.update(saveOrUpdateInfo, memberPriceLambdaQueryWrapper) > 0;

                saveOrUpdateInfo = adamMemberPriceMapper.selectList(memberPriceLambdaQueryWrapper).get(0);
            }
            if (saveOrUpdateRst) {
                String memberPriceId = saveOrUpdateInfo.getMemberPriceId();

                String mpKey = AdamRedisConst.INFO_MEMBER_PRICE.concat(memberId);
                List<AdamMemberPriceVo> vos = (List<AdamMemberPriceVo>) redisDataSourceUtil.getRedisAdamUtil().get(mpKey);
                vos.removeIf(r -> (r.getMemberId().equals(memberId) && r.getMemberPriceId().equals(memberPriceId)));

                vos.add(AdamMemberPriceVo.getNew().copy(saveOrUpdateInfo));
                redisDataSourceUtil.getRedisAdamUtil().set(mpKey, vos);
                return true;
            }
            throw new LiquidnetServiceException("-1", "会员价格编辑失败");
        }
        return false;
    }
}
