package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.candy.vo.CandyCouponRulesVo;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinOrderSku;
import com.liquidnet.service.goblin.param.*;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;

@Slf4j
@Service
public class GoblinCouponImpl implements GoblinCouponService {
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinOrderUtils orderUtils;

    @Override
    public ArrayList<String> getSpuType(String spuId, String storeId) {
        ArrayList<String> returnList = CollectionUtil.arrayListString();
        String pre = GoblinStatusConst.MarketPreStatus.getPre(spuId);
        if (pre != null) {
            spuId = spuId.split(pre)[0];
        }
        List<GoblinStoreCouponVo> listVo = goblinRedisUtils.getGoodsMarketsForCoupon(spuId, storeId);
        LocalDateTime now = LocalDateTime.now();
        for (GoblinStoreCouponVo vo : listVo) {
            if (!returnList.contains(vo.getType()) && "1".equals(vo.getReceiveCurb())
                    && now.isAfter(vo.getStartTime()) && now.isBefore(vo.getEndTime())) {
                returnList.add(vo.getType());
            }
        }
        return returnList;
    }

    @Override
    public ArrayList<GoblinStoreCouponVo> getSpuByType(String spuId, String storeId, String type) {
        ArrayList<GoblinStoreCouponVo> returnList = ObjectUtil.getGoblinStoreCouponVoArrayList();
        String pre = GoblinStatusConst.MarketPreStatus.getPre(spuId);
        if (pre != null) {
            spuId = spuId.split(pre)[0];
        }
        List<GoblinStoreCouponVo> listVo = goblinRedisUtils.getGoodsMarketsForCoupon(spuId, storeId);
        LocalDateTime now = LocalDateTime.now();
        for (GoblinStoreCouponVo vo : listVo) {
            if ((vo.getType().equals(type) || type.equals("0")) && "1".equals(vo.getReceiveCurb())
                    && now.isAfter(vo.getStartTime()) && now.isBefore(vo.getEndTime())) {
//                vo.setStock(null);
                if (0 == vo.getStock()) {// 无限库存
                    vo.setStock(1);
                } else {// 有限库存
                    int surplusStock = goblinRedisUtils.getStoreCouponStock(vo.getStoreCouponId());
                    vo.setStock(surplusStock == 0 ? 0 : 1);
                }
                returnList.add(vo);
            }
        }
        return returnList;
    }

    @Override
    public Boolean receiveCoupon(String uid, List<GoblinUserCouponVo> userCouponVoList, GoblinStoreCouponVo storeCouponVo) {
        String storeCouponId = storeCouponVo.getStoreCouponId();
        if (storeCouponVo.getStock().equals(0) || goblinRedisUtils.decrStoreCouponStock(storeCouponId, 1) >= 0) {
            LocalDateTime now = LocalDateTime.now();
            GoblinUserCouponBasicVo receiveUserCouponBasicVo = GoblinUserCouponBasicVo.getNew().initByStoreCouponVo(storeCouponVo);
            receiveUserCouponBasicVo.setUid(uid);
            receiveUserCouponBasicVo.setBindAt(now);
            receiveUserCouponBasicVo.setOperator(uid);
            receiveUserCouponBasicVo.setCreatedAt(now);

            userCouponVoList.add(GoblinUserCouponVo.getNew().copy(receiveUserCouponBasicVo));

//            long s = System.nanoTime();
            goblinMongoUtils.insertUserCouponVo(receiveUserCouponBasicVo);
//            log.info("MDB.I耗时:{}ms", (System.nanoTime() - s) / 1000000);
//            s = System.nanoTime();
            goblinRedisUtils.setUserCouponVos(uid, userCouponVoList);
//            log.info("RDS.S耗时:{}ms", (System.nanoTime() - s) / 1000000);

            LinkedList<Object[]> initUserCouponObjs = CollectionUtil.linkedListObjectArr();
            initUserCouponObjs.add(new Object[]{
                    receiveUserCouponBasicVo.getUcouponId(), receiveUserCouponBasicVo.getStoreCouponId(), receiveUserCouponBasicVo.getUid(),
                    receiveUserCouponBasicVo.getState(), receiveUserCouponBasicVo.getBindAt(), receiveUserCouponBasicVo.getDuedAt(),
                    receiveUserCouponBasicVo.getOperator(), receiveUserCouponBasicVo.getCreatedAt()
            });
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_COUPON.getKey(),
                    SqlMapping.get("goblin_user_coupon.insert", initUserCouponObjs));
            return true;
        }
        if (!storeCouponVo.getStock().equals(0)) {
            goblinRedisUtils.incrStoreCouponStock(storeCouponId, 1);
        }
        return false;
    }

    @Override
    public List<GoblinUserCouponVo> getList(String type) {
        String uid = CurrentUtil.getCurrentUid();
        List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(uid);
        List<GoblinUserCouponVo> returnList = ObjectUtil.getGoblinUserCouponVo();
//        HashMap<String, String> storeIdNameMap = CollectionUtil.mapStringString();
//        GoblinStoreInfoVo storeInfoVoTmp;
        LocalDateTime now = LocalDateTime.now();
        for (GoblinUserCouponVo vo : voList) {
//            if (StringUtils.isNotEmpty(vo.getStoreId())) {
//                storeInfoVoTmp = goblinRedisUtils.getStoreInfoVo(vo.getStoreId());
//                vo.setStoreName(storeIdNameMap.getOrDefault(vo.getStoreId(), null == storeInfoVoTmp ? null : storeInfoVoTmp.getStoreName()));
//            }
            if ("1".equals(type)) {
                if (vo.getDuedAt().isAfter(now) && vo.getState().equals(1)) {
                    vo.setSpuIds(goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId()));
                    returnList.add(vo);
                }
            } else {
                if (vo.getDuedAt().isBefore(now) || vo.getState().equals(3)) {
                    vo.setState(3);
                    vo.setSpuIds(goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId()));
                    returnList.add(vo);
                }
                if (vo.getState().equals(5)) {
                    vo.setSpuIds(goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId()));
                    returnList.add(vo);
                }
            }

        }
        return returnList;
    }

    @Override
    public GoblinUserCouponVo canUse(BigDecimal totalPrice, String spuId, String uid, String storeId) {
        BigDecimal maxPrice = BigDecimal.ZERO;
        GoblinUserCouponVo returnVo = GoblinUserCouponVo.getNew();
        List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(uid);

        LocalDateTime now = LocalDateTime.now();
        for (GoblinUserCouponVo vo : voList) {
            //判断券状态 和 触发金额
            if (vo.getDuedAt().isAfter(now) && vo.getState().equals(1) && vo.getTriggers().compareTo(totalPrice) <= 0 && vo.getStoreId().equals(storeId)) {
                if (vo.getUseScope().equals("0")) {
                    BigDecimal tempPrice = BigDecimal.ZERO;
                    if (vo.getType().equals("1")) {//代金券
                        tempPrice = vo.getValFace();
                    } else if (vo.getType().equals("2")) {//折扣
                        tempPrice = totalPrice.multiply(vo.getDiscount()).setScale(2, BigDecimal.ROUND_HALF_UP);
                        if (tempPrice.compareTo(vo.getDeduction()) > 0) {
                            tempPrice = vo.getDeduction();
                        }
                    } else if (vo.getType().equals("3") && vo.getTriggers().compareTo(totalPrice) <= 0) {//满减
                        tempPrice = vo.getValMinus();
                    }
                    if (maxPrice.compareTo(tempPrice) < 0) {
                        maxPrice = tempPrice;
                        returnVo = vo;
                    }
                } else {
                    List<String> spuIds = goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId());
                    if (spuId == null) {
                        continue;
                    }
                    //判断是否在可用商品内
                    for (String item : spuIds) {
                        List<String> spuList = Arrays.asList(spuId.split(","));
                        if (spuList.contains(item)) {
                            BigDecimal tempPrice = BigDecimal.ZERO;
                            if (vo.getType().equals("1")) {//代金券
                                tempPrice = vo.getValFace();
                            } else if (vo.getType().equals("2")) {//折扣
                                tempPrice = totalPrice.multiply(vo.getDiscount()).setScale(2, BigDecimal.ROUND_HALF_UP);
                                if (tempPrice.compareTo(vo.getDeduction()) > 0) {
                                    tempPrice = vo.getDeduction();
                                }
                            } else if (vo.getType().equals("3") && vo.getTriggers().compareTo(totalPrice) <= 0) {//满减
                                tempPrice = vo.getValMinus();
                            }
                            if (maxPrice.compareTo(tempPrice) < 0) {
                                maxPrice = tempPrice;
                                returnVo = vo;
                            }
                        }
                    }
                }
            }
        }
        return returnVo;
    }

    @Override
    public List<GoblinUserCouponVo> useList(BigDecimal totalPrice, String spuId, String uid) {
        List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(uid);
        List<GoblinUserCouponVo> returnList = ObjectUtil.getGoblinUserCouponVo();

        LocalDateTime now = LocalDateTime.now();
        for (GoblinUserCouponVo vo : voList) {
            //判断券状态 和 触发金额
            if (vo.getDuedAt().isAfter(now) && vo.getState().equals(1) && vo.getTriggers().compareTo(totalPrice) <= 0) {
                if (vo.getUseScope().equals("0")) {
                    vo.setSpuIds(CollectionUtil.linkedListString());
                    returnList.add(vo);
                } else {
                    List<String> spuIds = goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId());
                    if (spuId == null) {
                        break;
                    }
                    //判断是否在可用商品内
                    for (String item : spuIds) {
                        List<String> spuList = Arrays.asList(spuId.split(","));
                        if (spuList.contains(item)) {
                            vo.setSpuIds(spuIds);
                            returnList.add(vo);
                            break;
                        }
                    }
                }
            }
        }
        returnList.sort(Comparator.comparing(GoblinUserCouponVo::getState));
        return returnList;
    }

    @Override
    public List<GoblinUserCouponVo> useList3(CouponCanUseAllParam param) {
        List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(param.getUid());
        List<GoblinUserCouponVo> returnList = ObjectUtil.getGoblinUserCouponVo();

        LocalDateTime now = LocalDateTime.now();
        for (GoblinUserCouponVo vo : voList) {
            //判断券状态 和 触发金额
            if (vo.getDuedAt().isAfter(now) && vo.getState().equals(1)) {
                if (vo.getUseScope().equals("0")) {
                    vo.setSpuIds(CollectionUtil.linkedListString());
                    returnList.add(vo);
                } else {
                    List<String> spuIds = goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId());
                    //判断是否在可用商品内
                    for (String item : spuIds) {
                        List<String> spuList = param.getSpuIds();
                        if (spuList.contains(item)) {
                            vo.setSpuIds(spuIds);
                            returnList.add(vo);
                            break;
                        }
                    }
                }
            }
        }
        returnList.sort(Comparator.comparing(GoblinUserCouponVo::getState));
        return returnList;
    }

    @Override
    public List<GoblinUserCouponVo> useList2(CouponCanUseParam param) {
        List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(param.getUid());
        List<GoblinUserCouponVo> returnList = ObjectUtil.getGoblinUserCouponVo();
        BigDecimal totalPrice = BigDecimal.ZERO;
        for (CouponCanUse2Param param2 : param.getParam()) {
            totalPrice = totalPrice.add(param2.getPrice());
        }
        LocalDateTime now = LocalDateTime.now();
        for (GoblinUserCouponVo vo : voList) {
            //判断券状态 和 触发金额
            if (vo.getDuedAt().isAfter(now) && vo.getState().equals(1)) {//&& vo.getTriggers().compareTo(totalPrice) <= 0
                if (vo.getUseScope().equals("0") && vo.getTriggers().compareTo(totalPrice) <= 0) {
                    vo.setSpuIds(CollectionUtil.linkedListString());
                    returnList.add(vo);
                } else {
                    List<String> spuIds = goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId());
                    if (spuIds == null || spuIds.size() == 0) {
                        break;
                    }
                    //判断是否在可用商品内
                    BigDecimal contentPrice = BigDecimal.ZERO;
                    for (String item : spuIds) {
                        for (CouponCanUse2Param param2 : param.getParam()) {
                            String pre = GoblinStatusConst.MarketPreStatus.getPre(param2.getSpuId());
                            String spuId = param2.getSpuId();
                            if (pre != null) {
                                spuId = param2.getSpuId().split(pre)[0];
                            }
                            if (spuId.equals(item)) {
                                contentPrice = contentPrice.add(param2.getPrice());
                            }
                        }
                    }
                    if (vo.getTriggers().compareTo(contentPrice) <= 0) {
                        vo.setSpuIds(spuIds);
                        returnList.add(vo);
                    }
                }
            }
        }
        returnList.sort(Comparator.comparing(GoblinUserCouponVo::getState));
        return returnList;
    }

    @Override
    public GoblinUseResultVo useCoupon(String ucouponId, String content, BigDecimal totalPrice, String spuId, String uid) {
        List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(uid);
        GoblinUseResultVo returnVo = GoblinUseResultVo.getNew();
        returnVo.setValue(BigDecimal.ZERO);
        returnVo.setCouType("-1");

        LocalDateTime now = LocalDateTime.now();
        for (GoblinUserCouponVo vo : voList) {
            if (vo.getUcouponId().equals(ucouponId)) {
                //判断券状态 和 触发金额
                if (vo.getDuedAt().isAfter(now) && vo.getState().equals(1) && vo.getTriggers().compareTo(totalPrice) <= 0) {
                    if (vo.getUseScope().equals("0")) {
                        if (vo.getType().equals("1")) {//代金券
                            returnVo.setValue(vo.getValFace());
                            returnVo.setCouType(vo.getType());
                        } else if (vo.getType().equals("2")) {//折扣
                            BigDecimal tempPrice = totalPrice.multiply(vo.getDiscount()).setScale(2, BigDecimal.ROUND_HALF_UP);
                            if (tempPrice.compareTo(vo.getDeduction()) > 0) {
                                tempPrice = vo.getDeduction();
                            }
                            returnVo.setValue(tempPrice);
                            returnVo.setCouType(vo.getType());
                        } else if (vo.getType().equals("3") && vo.getTriggers().compareTo(totalPrice) <= 0) {//满减
                            returnVo.setValue(vo.getValMinus());
                            returnVo.setCouType(vo.getType());
                        }
                        vo.setState(5);
                        vo.setUsedFor(content);
                        goblinMongoUtils.changeCouponVos(vo.getUcouponId(), vo);
                        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_COUPON.getKey(),
                                SqlMapping.get("goblin_user_coupon.updateState", vo.getState(), vo.getUsedFor(), LocalDateTime.now(), vo.getUcouponId()));
                        break;
                    } else {
                        List<String> spuIds = goblinRedisUtils.getStoreCouponSpuIds(vo.getStoreCouponId());
                        if (spuId == null) {
                            continue;
                        }
                        //判断是否在可用商品内
                        List<String> spuList = Arrays.asList(spuId.split(","));
                        for (String item : spuIds) {
                            if (spuList.contains(item)) {
                                if (vo.getType().equals("1")) {//代金券
                                    returnVo.setValue(vo.getValFace());
                                    returnVo.setCouType(vo.getType());
                                } else if (vo.getType().equals("2")) {//折扣
                                    BigDecimal tempPrice = totalPrice.multiply(vo.getDiscount()).setScale(2, BigDecimal.ROUND_HALF_UP);
                                    if (tempPrice.compareTo(vo.getDeduction()) > 0) {
                                        tempPrice = vo.getDeduction();
                                    }
                                    returnVo.setValue(tempPrice);
                                    returnVo.setCouType(vo.getType());
                                } else if (vo.getType().equals("3") && vo.getTriggers().compareTo(totalPrice) <= 0) {//满减
                                    returnVo.setValue(vo.getValMinus());
                                    returnVo.setCouType(vo.getType());
                                }
                                vo.setState(5);
                                vo.setUsedFor(content);
                                goblinMongoUtils.changeCouponVos(vo.getUcouponId(), vo);
                                queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_COUPON.getKey(),
                                        SqlMapping.get("goblin_user_coupon.updateState", vo.getState(), vo.getUsedFor(), LocalDateTime.now(), vo.getUcouponId()));
                            }
                            break;
                        }
                    }
                }
                break;
            }
        }
        if (!returnVo.getCouType().equals("-1")) {
            goblinRedisUtils.setUserCouponVos(uid, voList);
        }
        return returnVo;
    }

    @Override
    public Boolean backCoupon(List<BackCouponParam> params) {
        try {
            for (BackCouponParam item : params) {
                List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(item.getUid());
                for (GoblinUserCouponVo vo : voList) {
                    if (vo.getUcouponId().equals(item.getuCouponIds())) {
                        if (LocalDateTime.now().isBefore(vo.getDuedAt())) {
                            vo.setState(1);
                            vo.setUsedFor("");
                            goblinRedisUtils.setUserCouponVos(item.getUid(), voList);
                            goblinMongoUtils.changeCouponVos(vo.getUcouponId(), vo);
                            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_COUPON.getKey(),
                                    SqlMapping.get("goblin_user_coupon.updateState", vo.getState(), vo.getUsedFor(), LocalDateTime.now(), vo.getUcouponId()));
                        }
                        break;
                    }
                }
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public CouponHelpUseVo helpUseCoupon(CouponHelpUseParam params) {
        LocalDateTime now = LocalDateTime.now();
        CouponHelpUseVo vo = CouponHelpUseVo.getNew();
        GoblinUseResultVo returnVo;
        String ucouponId = params.getUcouponId();
        String platformUcouponId = params.getPlatformUcouponId();
        vo.setPrice(BigDecimal.ZERO);
        //店铺券
        if (ucouponId != null && !ucouponId.equals("")) {
            List<GoblinUserCouponVo> voList = goblinRedisUtils.getUserCouponVos(params.getUid());
            for (GoblinUserCouponVo itemVo : voList) {
                if (itemVo.getUcouponId().equals(ucouponId)) {
                    if (itemVo.getUcouponId().equals(ucouponId) && itemVo.getDuedAt().isAfter(now) && itemVo.getState().equals(1)) {
                        BigDecimal contentPrice = BigDecimal.ZERO;
                        if (itemVo.getUseScope().equals("0")) {//全部
                            for (CouponCanUse2Param item : params.getParam()) {
                                contentPrice = contentPrice.add(item.getPrice());
                            }
                            returnVo = mathCouponPrice(itemVo, contentPrice);
                        } else {//部分
                            List<String> spuIds = goblinRedisUtils.getStoreCouponSpuIds(itemVo.getStoreCouponId());
                            if (spuIds == null || spuIds.size() == 0) {
                                break;
                            }
                            //判断是否在可用商品内
                            for (String spuItem : spuIds) {
                                for (CouponCanUse2Param item : params.getParam()) {
                                    String spuId = item.getSpuId();
                                    String pre = GoblinStatusConst.MarketPreStatus.getPre(spuId);
                                    if (pre != null) {
                                        spuId = spuId.split(pre)[0];
                                    }
                                    if (spuId.equals(spuItem)) {
                                        contentPrice = contentPrice.add(item.getPrice());
                                    }
                                }
                            }
                            returnVo = mathCouponPrice(itemVo, contentPrice);
//                        returnVo.setSpuIds(spuIds);
                        }
//                    List<String> spuIdList = returnVo.getSpuIds();
                        BigDecimal voucherPrice = returnVo.getValue();
//                    if (spuIdList.size() > 0) {
//                        for (String spuId : spuIdList) {
//                            for (CouponCanUse2Param paramItem : params.getParam()) {
//                                if (paramItem.getSpuId().contains(spuId)) {
//                                    if (voucherPrice.compareTo(BigDecimal.ZERO) >= 0) {
//                                        voucherPrice = voucherPrice.subtract(paramItem.getPrice());
//                                        if (voucherPrice.compareTo(BigDecimal.ZERO) >= 0) {
//                                            paramItem.setPrice(paramItem.getPrice());
//                                        } else {
//                                            paramItem.setPrice(voucherPrice.add(paramItem.getPrice()));
//                                        }
//                                    }
//                                }
//                            }
//                        }
//                    } else {
//                        for (CouponCanUse2Param paramItem : params.getParam()) {
//                            if (voucherPrice.compareTo(BigDecimal.ZERO) >= 0) {
//                                voucherPrice = voucherPrice.subtract(paramItem.getPrice());
//                                if (voucherPrice.compareTo(BigDecimal.ZERO) >= 0) {
//                                    paramItem.setPrice(paramItem.getPrice());
//                                } else {
//                                    paramItem.setPrice(voucherPrice.add(paramItem.getPrice()));
//                                }
//                            }
//                        }
//                    }
//                    vo.setParam(params.getParam());
//                    vo.setCouponVo(itemVo);
                        vo.setPrice(voucherPrice);
                        break;
                    }
                }
            }
        } else if (platformUcouponId != null && !platformUcouponId.equals("")) {
            CandyCouponVo candyCouponVo = orderUtils.getCouponDetails(platformUcouponId);
            if(candyCouponVo==null){
                return null;
            }
            if (candyCouponVo.getState().equals(1) && (candyCouponVo.getBusiType().equals(0) || candyCouponVo.getBusiType().equals(2))) {
                BigDecimal voucherPrice;
                switch (candyCouponVo.getCouType()) {
                    case 1://代金
                        vo.setPrice(candyCouponVo.getValFace());
                        break;
                    case 2://满减
                        voucherPrice = mathPlatformPrice(candyCouponVo, params.getParam());
                        if (voucherPrice.compareTo(candyCouponVo.getValOver()) >= 0) {
                            vo.setPrice(candyCouponVo.getValMinus());
                        }
                        break;
                    case 4://折扣
                        voucherPrice = mathPlatformPrice(candyCouponVo, params.getParam());
                        vo.setPrice(voucherPrice.subtract(voucherPrice.multiply(candyCouponVo.getDiscount())));
                        break;
                }
            }

        }
        vo.setUcouponId(ucouponId);
        vo.setPlatformUcouponId(platformUcouponId);
        return vo;
    }

    //用券计算金额 返回优惠金额和类型
    private GoblinUseResultVo mathCouponPrice(GoblinUserCouponVo vo, BigDecimal contentPrice) {
        GoblinUseResultVo returnVo = GoblinUseResultVo.getNew();
        returnVo.setValue(BigDecimal.ZERO);
        if (vo.getTriggers().compareTo(contentPrice) <= 0) {
            if (vo.getType().equals("1")) {//代金券
                if (vo.getValFace().compareTo(contentPrice) > 0) {
                    returnVo.setValue(contentPrice);
                } else {
                    returnVo.setValue(vo.getValFace());
                }
                returnVo.setCouType(vo.getType());
            } else if (vo.getType().equals("2")) {//折扣
                BigDecimal tempPrice = contentPrice.multiply(vo.getDiscount()).setScale(2, BigDecimal.ROUND_HALF_UP);
                if (tempPrice.compareTo(vo.getDeduction()) > 0) {
                    tempPrice = vo.getDeduction();
                }
                returnVo.setValue(contentPrice.subtract(tempPrice));
                returnVo.setCouType(vo.getType());
            } else if (vo.getType().equals("3")) {//满减
                if (vo.getValMinus().compareTo(contentPrice) > 0) {
                    returnVo.setValue(contentPrice);
                } else {
                    returnVo.setValue(vo.getValMinus());
                }
                returnVo.setCouType(vo.getType());
            }
        }
        return returnVo;
    }

    //计算平台券金额
    private BigDecimal mathPlatformPrice(CandyCouponVo candyCouponVo, List<CouponCanUse2Param> param) {
        BigDecimal voucherPrice = BigDecimal.ZERO;
        for (CandyCouponRulesVo couponRulesVo : candyCouponVo.getUseRules()) {
            if (couponRulesVo.getUseScope().equals(101)) {
                break;
            }
            if (couponRulesVo.getUseScope().equals(80)) {
                for (CouponCanUse2Param couponCanUse2Param : param) {
                    String orderVoSpuId = couponCanUse2Param.getSpuId();
                    String pre = GoblinStatusConst.MarketPreStatus.getPre(orderVoSpuId);
                    if (pre != null) {
                        orderVoSpuId = orderVoSpuId.split(pre)[0];
                    }
                    if (couponRulesVo.getBusiId().equals(orderVoSpuId)) {
                        voucherPrice = voucherPrice.add(couponCanUse2Param.getPrice());
                    }
                }
            }
        }
        return voucherPrice;
    }
}
