package com.liquidnet.service.goblin.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamRscPolymer01Vo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.param.BackCouponParam;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.candy.vo.CandyUseResultVo;
import com.sun.org.apache.xpath.internal.operations.Bool;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
@Slf4j
public class GoblinOrderUtils {

    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;
    @Value("${liquidnet.service.candy.url}")
    private String candyUrl;
    @Value("${liquidnet.service.stone.url}")
    private String stoneUrl;
    @Autowired
    GoblinRedisUtils redisUtils;

    public void backCoupon(String uCouponId, String uid) {
        try {
            BackCouponParam param = BackCouponParam.getNew();
            param.setuCouponIds(uCouponId);
            param.setUid(uid);

            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Authorization", "Bearer " + CurrentUtil.getToken());
            header.add("Accept", "application/json;charset=UTF-8");
            ArrayList<BackCouponParam> params = new ArrayList();
            params.add(param);
            String jsonString = JSON.toJSONString(params);
            String returnData = HttpUtil.postRaw(candyUrl + "/candy-coupon/useBack", jsonString, header);
        } catch (Exception e) {
            log.error("回退券ERROR:{}", e);
        }
    }

    public CandyCouponVo getCouponDetails(String uCouponId) {
        try {
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Authorization", "Bearer " + CurrentUtil.getToken());
            header.add("Accept", "application/json;charset=UTF-8");

            MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
            params.add("uCouponIds", uCouponId);
            String returnData = HttpUtil.post(candyUrl + " /candy-coupon/receive/ListById", params, header);
            ResponseDto<List<CandyCouponVo>> innerReturnVo = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<List<CandyCouponVo>>>() {
            });
            if(innerReturnVo.getData().size()>0){
                return innerReturnVo.getData().get(0);
            }else{
                return null;
            }
        } catch (Exception e) {
            log.error("回退券ERROR:{}", e);
            CandyCouponVo vo = CandyCouponVo.getNew();
            vo.setUcouponId(uCouponId);
            vo.setTitle("");
            return vo;
        }
    }

    public void doTask(String uid, BigDecimal price) {
        try {
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Accept", "application/json;charset=UTF-8");
            MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
            params.add("score", price.intValue() + "");
            params.add("content", "购买商品:");
            params.add("uid", uid);
            String resultData = HttpUtil.post(stoneUrl + "/user/logs/in2111", params, header);
        } catch (Exception e) {
            log.error("添加积分失败,e:{}", e);
            e.printStackTrace();
        }
    }
}
