/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.proxy;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.auth.Authenticator;
import com.taobao.api.internal.toplink.embedded.websocket.auth.Credentials;
import com.taobao.api.internal.toplink.embedded.websocket.auth.DefaultAuthenticator;
import com.taobao.api.internal.toplink.embedded.websocket.exception.ErrorCode;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.handshake.ProxyHandshake;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Proxy {
    private static Logger log = Logger.getLogger(Proxy.class.getName());
    private boolean autoDetect = false;
    private InetSocketAddress proxy;
    private Authenticator authenticator;
    private Credentials credentials;

    public Proxy() {
        this.autoDetect = true;
        this.authenticator = null;
    }

    public Proxy(InetSocketAddress proxyAddress) {
        this.proxy = proxyAddress;
        this.authenticator = null;
    }

    public Proxy(String username, String password) {
        this.autoDetect = true;
        this.authenticator = new DefaultAuthenticator();
        this.credentials = new Credentials(username, password);
    }

    public Proxy(Credentials credentials, Authenticator authenticator) {
        this.autoDetect = true;
        this.credentials = credentials;
        this.authenticator = authenticator;
    }

    public Proxy(InetSocketAddress proxyAddress, String username, String password) {
        this.proxy = proxyAddress;
        this.authenticator = new DefaultAuthenticator();
        this.credentials = new Credentials(username, password);
    }

    public Proxy(InetSocketAddress proxyAddress, Credentials credentials, Authenticator authenticator) {
        this.proxy = proxyAddress;
        this.authenticator = authenticator;
        this.credentials = credentials;
    }

    protected InetSocketAddress findProxy(InetSocketAddress endpoint) throws WebSocketException {
        block6: {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
                URI proxyUri = new URI("http", null, endpoint.getHostName(), endpoint.getPort(), null, null, null);
                List<java.net.Proxy> proxyList = ProxySelector.getDefault().select(proxyUri);
                if (proxyList == null || proxyList.size() <= 0 || proxyList.get(0).type().equals((Object)Proxy.Type.DIRECT)) break block6;
                if (log.isLoggable(Level.FINER)) {
                    int i = 1;
                    for (java.net.Proxy p : proxyList) {
                        log.finer("Proxy[" + i++ + "]" + p.toString());
                    }
                }
                InetSocketAddress address = (InetSocketAddress)proxyList.get(0).address();
                try {
                    address = new InetSocketAddress(InetAddress.getByName(address.getHostName()), address.getPort());
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                return address;
            }
            catch (URISyntaxException e) {
                throw new WebSocketException(ErrorCode.E3032, (Throwable)e);
            }
        }
        return null;
    }

    public ProxyHandshake getProxyHandshake(WebSocket ws) throws WebSocketException {
        InetSocketAddress proxy = null;
        if (this.autoDetect) {
            proxy = this.findProxy(ws.getEndpoint());
            if (proxy == null) {
                return null;
            }
        } else {
            proxy = this.proxy;
        }
        if (this.authenticator != null) {
            this.authenticator.init(ws, this.credentials);
        }
        ProxyHandshake proxyHandshake = new ProxyHandshake(proxy, ws.getEndpoint(), this.authenticator, ws);
        return proxyHandshake;
    }
}

