package com.liquidnet.service.consumer.dragon.service.processor;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.consumer.dragon.service.IBaseDao;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * ConsumerAdamProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerAdamUCenterProcessor {
    @Resource
    IBaseDao baseDao;

//    @RabbitListener(bindings = @QueueBinding(
//            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL), key = MQConst.ROUTING_KEY_SQL,
//            value = @Queue(MQConst.QUEUES_SQL_MAIN)
//    ))
////    @RabbitListener(queues = MQConst.QUEUES_SQL_MAIN)
//    public void consumerSql(Message msg, Channel channel) {
//        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
//        log.debug("CONSUMER SQL ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
//        log.debug("CONSUMER SQL ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));
//
//        try {
//            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
//            log.debug("CONSUMER SQL result of execution:{}", rstBatchSqls);
//            if (rstBatchSqls) {
//                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
//            } else {
//                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
//            }
//        } catch (Exception e) {
//            log.error("error:CONSUMER SQL:{}", JsonUtils.toJson(sqlMessage), e);
//            try {
//                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
//            } catch (IOException ioException) {
//                log.error("error:CONSUMER SQL:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
//            }
//        }
//    }

    private void consumerSqlDaoHandler(Message msg, Channel channel) {
        MessageProperties properties = msg.getMessageProperties();
        String consumerQueue = properties.getConsumerQueue();
        long deliveryTag = properties.getDeliveryTag();
        log.info("CONSUMER SQL ==> [consumerQueue:{},deliveryTag:{}]", consumerQueue, deliveryTag);
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("CONSUMER SQL ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("CONSUMER SQL ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));
        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER SQL result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(deliveryTag, false);
            } else {
                log.warn("###CONSUMER SQL[consumerQueue:{},deliveryTag={},sqlMessage:{}]", consumerQueue, deliveryTag, JsonUtils.toJson(sqlMessage));
                channel.basicAck(deliveryTag, false);
            }
        } catch (IOException e) {
            log.error("CONSUMER SQL[consumerQueue:{},deliveryTag:{},sqlMessage:{}]", consumerQueue, deliveryTag, JsonUtils.toJson(sqlMessage), e);
        }
    }

    /* ================================================================== ｜ 用户注册 */

    @RabbitListener(
            bindings = @QueueBinding(
                    exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER),
                    key = MQConst.RK_SQL_UREGISTER,
                    value = @Queue(MQConst.QUEUES_SQL_UREGISTER)
            ),
            concurrency = "5"
    )
    public void consumerSqlForURegister(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    /* ================================================================== ｜ 用户信息 */

    @RabbitListener(
            bindings = @QueueBinding(
                    exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER),
                    key = MQConst.RK_SQL_UCENTER,
                    value = @Queue(MQConst.QUEUES_SQL_UCENTER)
            ),
            concurrency = "5"
    )
    public void consumerSqlForUCenter(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    /* ================================================================== ｜ 会员购买 */

    @RabbitListener(
            bindings = @QueueBinding(
                    exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER),
                    key = MQConst.RK_SQL_UMEMBER,
                    value = @Queue(MQConst.QUEUES_SQL_UMEMBER)
            ),
            concurrency = "5"
    )
    public void consumerSqlForUMember(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    /* ================================================================== ｜  */
}
