package com.liquidnet.service.sweet.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Objects;

/**
 * <p>
 * 小程序登陆 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-27
 */
@Slf4j
@Service
public class SweetWechatLoginServiceImpl {

    @Value("${liquidnet.wechat.applet.strawberry.appid}")
    private String strawberryAppid;
    @Value("${liquidnet.wechat.applet.strawberry.secret}")
    private String strawberrySecret;

    @Value("${liquidnet.wechat.applet.five.appid}")
    private String fiveAppid;
    @Value("${liquidnet.wechat.applet.five.secret}")
    private String fiveSecret;

    @Value("${liquidnet.wechat.applet.mdsk.appid}")
    private String mdskAppid;
    @Value("${liquidnet.wechat.applet.mdsk.secret}")
    private String mdskSecret;

    public ResponseDto userInfo(String code, String encryptedData, String iv, Integer type) {
        log.info("\n参数code：[{}] ", code);
        log.info("\n参数encryptedData：[{}] ", encryptedData);
        log.info("\n参数iv：[{}] ", iv);
        log.info("\n参数type：[{}] ", type);
        try {
            String appId = "";
            String appSecret = "";
            switch (type) {
                case 1:
                    appId = strawberryAppid;
                    appSecret = strawberrySecret;
                    break;
                case 2:
                    appId = fiveAppid;
                    appSecret = fiveSecret;
                    break;
                case 3:
                    appId = mdskAppid;
                    appSecret = mdskSecret;
                    break;
            }
            WxMaConfig wxMaConfig = wxMaConfig(appId, appSecret);
            WxMaService wxMaService = wxMaService(wxMaConfig);
            WxMaJscode2SessionResult sessionInfo = wxMaService.getUserService().getSessionInfo(code);
            log.info("\nWxMaJscode2SessionResult：[{}] ", JsonUtils.toJson(sessionInfo));
            if (null == sessionInfo) {
                return ResponseDto.failure("login handler error");
            }

            // 解密用户信息
            WxMaUserInfo wxUserInfo = wxMaService.getUserService().getUserInfo(sessionInfo.getSessionKey(),
                    encryptedData, iv);
            log.info("\nWxMaUserInfo：[{}] ", JsonUtils.toJson(wxUserInfo));
            if (null == wxUserInfo) {
                return ResponseDto.failure("wxUser not exist");
            }

            // 解密手机号码信息
            WxMaPhoneNumberInfo wxMaPhoneNumberInfo = wxMaService.getUserService().getPhoneNoInfo(sessionInfo.getSessionKey(),
                    encryptedData, iv);
            log.info("\nWxMaPhoneNumberInfo：[{}] ", wxMaPhoneNumberInfo.toString());
            if (Objects.isNull(wxMaPhoneNumberInfo) || StringUtils.isBlank(wxMaPhoneNumberInfo.getPhoneNumber())) {
                return ResponseDto.failure("解密手机号码信息错误");
            }

            String unionId = sessionInfo.getUnionid();
            String openId = sessionInfo.getOpenid();

            HashMap userInfo = new HashMap();
            userInfo.put("unionId", unionId);
            userInfo.put("openId", openId);
            userInfo.put("getPhoneNumber", wxMaPhoneNumberInfo.getPhoneNumber());
            userInfo.put("getPurePhoneNumber", wxMaPhoneNumberInfo.getPurePhoneNumber());
            userInfo.put("getCountryCode", wxMaPhoneNumberInfo.getCountryCode());

            return ResponseDto.success(userInfo);
        } catch (Exception e) {
            log.info("\nprintStackTrace：[{}] ", e.getMessage());
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    private WxMaConfig wxMaConfig(String appId, String appSecret) {
        WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
        config.setAppid(appId);
        config.setSecret(appSecret);
        config.setMsgDataFormat("JSON");
        return config;
    }

    private WxMaService wxMaService(WxMaConfig maConfig) {
        WxMaService service = new WxMaServiceImpl();
        service.setWxMaConfig(maConfig);
        return service;
    }

}
