package com.liquidnet.common.exception.entity;

import lombok.Data;

import java.io.Serializable;

@Data
public class Error implements Serializable, Cloneable {
    String message;
    String code;
    Object data;

    public Error() {
    }

    public Error(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public Error setMessage(String message) {
        this.message = message;
        return this;
    }

    public Error setCode(String code) {
        this.code = code;
        return this;
    }

    public Error setData(Object data) {
        this.data = data;
        return this;
    }

    private static final Error obj = new Error();

    public static Error getNew() {
        try {
            return (Error) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Error();
        }
    }

}
