--  导入数据库 --
drop table if exists kylin_order_import;
create table kylin_order_import
(
    mid        bigint unsigned auto_increment primary key,
    import_id  varchar(64) default '' comment 'id',
    performance_id  varchar(64) default '' comment '演出id',
    title    varchar(64) default '' comment '文件名称',
    status     int(3) default 0 comment '状态[0-处理中|1处理完成|2处理失败]',

    error_count     int default 0 comment '失败条数',
    success_count     int default 0 comment '成功条数',
    all_count     int default 0 comment '总条数',
    created_at datetime ,
    updated_at datetime ,
    comment    text
) engine = InnoDB comment '订单导入表';

--  退款配置添加  --
ALTER TABLE kylin_performance_status ADD is_refund_poundage tinyint DEFAULT 0 COMMENT '是否有手续费';
ALTER TABLE kylin_performance_status ADD is_refund_voucher tinyint DEFAULT 0 COMMENT '是否退优惠券';
ALTER TABLE kylin_performance_status ADD is_refund_express tinyint DEFAULT 0 COMMENT '是否快递费';

-- 订单相关券逻辑添加 --
drop TABLE if exists `kylin_order_coupons`;
CREATE TABLE `kylin_order_coupons`
(
    `mid`                  int              NOT NULL AUTO_INCREMENT,
    `order_id`             varchar(255)     NOT NULL DEFAULT '' COMMENT '订单id',
    `coupon_code`         varchar(255)     NOT NULL DEFAULT '' COMMENT '券code = 券id',
    `coupon_type`         tinyint          NOT NULL DEFAULT 0 COMMENT '券类别',
    `coupon_price`        decimal(8, 2)    NOT NULL DEFAULT 0.0 COMMENT '券的优惠金额',
    `comment`               varchar(200)   NOT NULL DEFAULT '' COMMENT '备用',
    `created_at`           datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`           datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_coupons_order_coupon_code_index` (`coupon_code`),
    KEY `kylin_order_coupons_order_id_index` (`order_id`),
    KEY `kylin_order_coupons_voucher_type_index` (`coupon_type`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '订单券 关联表';

-- >>------------------------------------------------------------------------------------ |20210817会员与券改版
# 添加`双倍积分`开关
alter table adam_member add integral_rate decimal(8, 2) default 0 null comment '积分倍率X100' after state;
# 添加`是否开售`开关，新增开售开关字段
alter table adam_member add onsale tinyint default 0 null comment '是否开售:1-开售｜2-停售' after integral_rate;
# 添加限购逻辑，新增限购开始、结束时间字段
alter table adam_member add limitb_at datetime(3) null comment '限购开始时间' after limitation;
alter table adam_member add limite_at datetime(3) null comment '限购结束时间' after limitb_at;


# 添加会员价格字段
alter table adam_member_price modify price_fixed decimal(8, 2) null comment '购买价格';
alter table adam_member_price add price_special decimal(8, 2) null comment '特价:首次、首年优惠价' after price_fixed;

# 会员码表调整
alter table adam_member_code modify state tinyint null comment '状态[0-可用|1-已用|2-无效]';
create index idx_amember_code_id on adam_member_code (code);
alter table adam_member_code add validity int null comment '有效期（单位天）' after state;
alter table adam_member_code add effect_at datetime(3) null comment '生效时间' after validity;
alter table adam_member_code add expire_at datetime(3) null comment '过期时间' after effect_at;
alter table adam_member_code add operator varchar(64) null comment '管理操作人' after expire_at;

# 订单
alter table adam_member_order modify state tinyint null comment '订单状态:0-未支付,1-已支付,2-已关闭,3-超时付,4-退款中,5-已退款';
alter table adam_member_order modify pay_no varchar(64) null comment '支付中心支付CODE';
alter table adam_member_order add payment_id varchar(64) null comment '支付中心三方支付ID' after pay_no;
alter table adam_member_order add area varchar(100) null comment '地区' after birthday;


# 会员退款
drop table if exists adam_member_refund;
create table adam_member_refund
(
    mid           bigint unsigned auto_increment primary key,
    refund_no     varchar(64) comment '退款请求编号',
    order_no      varchar(64) not null comment '对应支付中心order_code',

    refund_price  decimal(8, 2) comment '退款金额',
    refund_reason varchar(200) comment '退款描述',
    renewable     tinyint comment '继续购买[1-可以｜2-不可]',
    refund_state  tinyint comment '退款状态[0-发起退款｜1-已退款｜2-关闭｜3-退款失败｜9-退款中]',
#     payment_type  varchar(30) comment '支付渠道（即UPPER(CONCAT(device_from,pay_type))）',

    repay_no      varchar(64) comment '支付中心退款编号',
    repay_reason  varchar(200) comment '支付中心退款描述',
    refund_at     datetime(3) comment '退款时间',

    operator      varchar(64) comment '操作人',
    created_at    datetime(3) not null,
    updated_at    datetime(3),

    comment       varchar(255)
) engine = InnoDB comment '会员退款';
create unique index uidx_adam_member_refund_id on adam_member_refund (refund_no);


# 添加权益管理（关联会员券）
drop table if exists adam_member_rights;
create table adam_member_rights
(
    mid        bigint unsigned auto_increment primary key,
    mrights_id varchar(64) not null,
    member_id  varchar(64) comment '会员类型id',
    state      tinyint comment '权益状态[0-INIT|1-NORMAL|2-INVALID]',
    seq_no     smallint comment '排列序号',
    title      varchar(50) not null comment '权益标题',
    sub_title  varchar(200) comment '副标题',
    label      varchar(50) comment '标注',
    cover      varchar(255) comment '图片标识',
    detail     text comment '详情内容',

    operator   varchar(64) comment '操作人',
    created_at datetime(3) not null,
    updated_at datetime(3),

    comment    varchar(255)
) engine = InnoDB comment '会员权益配置';
create unique index uidx_adam_member_rights_id on adam_member_rights (mrights_id);
-- >>------------------------------------------------------------------------------------ |20210918社交相关
# 用户业务服务账号表
drop table if exists adam_user_busi_acct;
create table adam_user_busi_acct
(
    mid        bigint unsigned auto_increment primary key,
    uid        varchar(64) not null,
    busi       varchar(20) comment '业务服务平台',
    uuid       varchar(64) comment '业务服务ID',
    work       varchar(64) comment '业务服务模块',
    ppwd       varchar(64) comment '业务服务密码',
    state      tinyint comment '1-NORMAL,2-INVALID',
    created_at datetime(3) not null,
    updated_at datetime(3),
    comment    text
) engine = InnoDB comment '用户业务服务账号表';
create index idx_adam_user_busi_acct_uid on adam_user_busi_acct (uid);
-- >>------------------------------------------------------------------------------------|20210924会员码管理
-- >>------------------------------------------------------------------------------------|20210924会员码管理
drop table if exists adam_member_code_batch;
create table adam_member_code_batch
(
    mid             bigint unsigned auto_increment primary key,
    batch_no        varchar(64) not null comment '会员码批次号',
    member_id       varchar(64) not null comment '~`adam_member.member_id`',
    member_price_id varchar(64) not null comment '~`adam_member_price.member_price_id`',
    member_name     varchar(80) comment '会员卡名称~`adam_member.name`',
    member_combo    varchar(80) comment '套餐包名称',
    gen_num         int comment '生成数量',
    use_num         int comment '使用数量',
    detail          varchar(255) comment '描述',
    validity        int comment '有效期（单位天）',
    effect_at       datetime(3) null comment '生效时间',
    expire_at       datetime(3) null comment '失效时间',

    state           tinyint comment '状态[0-INIT|1-NORMAL|2-INVALID]',
    operator        varchar(64) comment '操作人',
    created_at      datetime(3) not null,
    updated_at      datetime(3),

    comment         varchar(255)
) engine = InnoDB comment '会员码批次记录';
create index idx_adam_member_code_batch_no on adam_member_code_batch (batch_no);

alter table adam_member_code add batch_no varchar(30) null comment '~`adam_member_code_batch.batch_no`' after type;
# -- >>------------------------------------------------------------------------------------ |20210817会员与券改版
# 券发放管理
drop table if exists candy_mgt_coupon;
create table candy_mgt_coupon
(
    mid         bigint unsigned auto_increment primary key,
    mcoupon_id  varchar(64) not null,
    coupon_id   varchar(64) not null comment '~candy_coupon.coupon_id',
    state       tinyint comment '发放状态[0-未发放|1-已发放|2-无效|3-已取消｜9-发放中|10-会员礼包初始模版]',

#     bind_type   smallint comment '领取方式[0-用户输入兑换｜1-发放至用户｜2-积分商品]',
    event_amt   int comment '发放量',
    event_type  tinyint comment '发放类型[0-保留｜1-会员｜2-手机号|10-全体用户]',
    event_limit text comment '`发放类型`为2-手机号时发放手机号以,分隔',
    event_at    datetime(3) comment '发放时间(立即-当前时间+3分钟｜预约-点选时间)',

    operator    varchar(64) not null comment '操作人',
    created_at  datetime(3) not null,
    updated_at  datetime(3),

    comment     text
) engine InnoDB comment '券发放管理';
create index idx_candy_mgt_coupon_id on candy_mgt_coupon (mcoupon_id);


# 券基础信息
drop table if exists candy_coupon;
create table candy_coupon
(
    mid             bigint unsigned auto_increment primary key,
    coupon_id       varchar(64) not null,
    state           tinyint comment '券状态[0-INIT|1-NORMAL|2-INVALID]',

    title           varchar(50) not null comment '券标题',
    label           varchar(50) comment '标注',
    notice          varchar(200) comment '注意/须知',
    exclusive       smallint comment '专享标识[0-常规｜1-会员礼包]',
    busi_type       smallint comment '业务类别[0-全场｜1-演出｜2-商品｜3-优先购]',
    cou_type        smallint comment '券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券|101-优先券]',
    bind_type       smallint comment '领取方式[0-用户输入兑换｜1-发放至用户｜2-积分商品]',

    discount        decimal(8, 2) comment '折扣[8折即0.8]',
    val_face        decimal(8, 2) comment '面值',
    val_over        decimal(8, 2) comment '满减~满',
    val_minus       decimal(8, 2) comment '满减~减',

    overlay         tinyint default 0 comment '叠加限制[0-限制｜1-叠加]',
    overlay_level   tinyint default 0 comment '#同类别券叠加适用',

    validity        int comment '有效期（单位天）',
    redeem_validity int comment '兑换有效期（单位天）',
    redeem_start    datetime(3) comment '兑换开放时间',
    redeem_stop     datetime(3) comment '兑换停止时间',
    effect_at       datetime(3) comment '生效时间',
    expire_at       datetime(3) comment '过期时间',

    operator        varchar(64) not null comment '操作人',
    created_at      datetime(3) not null,
    updated_at      datetime(3),

    comment         varchar(255)
) engine = InnoDB comment '券基础信息';
create unique index uidx_candy_coupon_id on candy_coupon (coupon_id);


# 券适用规则
drop table if exists candy_coupon_rule;
create table candy_coupon_rule
(
    mid       bigint unsigned auto_increment primary key,
    crule_id  varchar(64) not null,
    coupon_id varchar(64) not null,
    use_scope smallint comment '适用范围[100-全场｜90-演出｜80-商品]',
    busi_name varchar(64) comment '适用名称',
    busi_id   varchar(64) comment '适用ID',
    state     tinyint comment '0-INIT,1-NORMAL,2-INVALID',
    comment   varchar(255)
) engine = InnoDB comment '券适用规则';
create unique index uidx_candy_coupon_rule_id on candy_coupon_rule (crule_id);


# 券码信息
drop table if exists candy_coupon_code;
create table candy_coupon_code
(
    mid           bigint unsigned auto_increment primary key,
    ccode         varchar(64) not null comment '券码',
    coupon_id     varchar(64) not null comment '~candy_coupon.coupon_id',
    state         tinyint comment '状态[0-可用|1-已用|2-无效|3-过期｜4-失效｜5-退回]',

    ucoupon_id    varchar(64) comment '~candy_user_coupon.ucoupon_id',
    redeem_uid    varchar(64) comment '兑换用户UID',
    redeem_mobile varchar(64) comment '兑换用户手机号',
    redeem_at     datetime(3) comment '兑换时间',

    redeem_start  datetime(3) comment '兑换开放时间',
    redeem_stop   datetime(3) comment '兑换停止时间',

    operator      varchar(64) comment '操作人',
    created_at    datetime(3) not null,
    updated_at    datetime(3),

    comment       varchar(255)
) engine = InnoDB comment '券码信息';
create unique index uidx_candy_coupon_code_id on candy_coupon_code (ccode, coupon_id);


# 用户券信息
drop table if exists candy_user_coupon;
create table candy_user_coupon
(
    mid        bigint unsigned auto_increment primary key,
    ucoupon_id varchar(64) not null,
    mcoupon_id varchar(64) comment '~candy_mgt_coupon.mcoupon_id',
    uid        varchar(64) not null comment '~adam_user.uid',
    coupon_id  varchar(64) not null comment '~candy_coupon.coupon_id',
    state      tinyint comment '用户券状态[1-可用|2-无效｜3-已过期｜5-已使用]',

    ccode      varchar(64) comment '券码~candy_coupon_code.ccode',
    bind_at    datetime(3) comment '激活时间',
    dued_at    datetime(3) comment '到期时间',
    used_at    datetime(3) comment '使用时间',
    used_for   varchar(255) comment '用于记录购买的内容',

    operator      varchar(64) comment '操作人',
    created_at    datetime(3) not null,
    updated_at    datetime(3),

    comment    varchar(255)
) engine = InnoDB comment '用户券信息';
create unique index uidx_candy_user_coupon_id on candy_user_coupon (ucoupon_id);
create index idx_candy_ucoupon_uid_state on candy_user_coupon (uid, state);


# 公有券信息
drop table if exists candy_common_coupon;
create table candy_common_coupon
(
    mid        bigint unsigned auto_increment primary key,
    ccoupon_id varchar(64) not null,
    mcoupon_id varchar(64) not null comment '~candy_mgt_coupon.mcoupon_id',
    coupon_id  varchar(64) not null comment '~candy_coupon.coupon_id',
    state      tinyint comment '公有券状态[1-可用|2-无效｜3-已过期]',
    ranged     tinyint comment '公有券范围(~candy_mgt_coupon.event_type)',

    operator    varchar(64) not null comment '操作人',
    created_at  datetime(3) not null,
    updated_at  datetime(3),
    comment    varchar(255)
) engine = InnoDB comment '公有券信息';
-- >>------------------------------------------------------------------------------------

-- >>----------------------------------------jxl--------------------------------------------
# 快递票退款发货需要的字段
alter table kylin_order_express add send_type tinyint not null default 1 comment '发货类型 1发出 2用户退款发货' after freight_price;
alter table kylin_order_express add send_express_type tinyint not null default 0 comment '退票发货快递类型 1上门取件 2自主发货' after send_type;
alter table kylin_order_express add express_contacts varchar(255) not null default '' comment '退票发货快递人' after send_express_type;
alter table kylin_order_express add express_phone varchar(255) not null default '' comment '退票发货快递联系方式' after express_contacts;
alter table kylin_order_express add send_express_address varchar(255) not null default '' comment '退票发货快递地址' after express_phone;
alter table kylin_order_express add appointment_time varchar(255) not null default '' comment '退票发货快递预约取件时间' after send_express_address;
# 快递票退款审核 退款手续费需要的字段
alter table kylin_order_refunds add price_charges decimal(10, 2) NOT NULL DEFAULT '0.00' COMMENT '退款扣除的手续费金额' after price_express;
alter table kylin_order_refunds add ticket_audit_id varchar(255)   NOT NULL DEFAULT '' COMMENT '票务审核人id' after refuse;
alter table kylin_order_refunds add ticket_audit_name varchar(100)   NOT NULL DEFAULT '' COMMENT '票务审核人名称' after ticket_audit_id;
alter table kylin_order_refunds add ticket_audit_at timestamp      NULL     DEFAULT NULL COMMENT '票务审核时间' after ticket_audit_name;
alter table kylin_order_refunds add ticket_audit_remark varchar(200)   NOT NULL DEFAULT '' COMMENT '票务审核备至' after ticket_audit_at;
# 手续费
alter table kylin_order_tickets add refund_price_charges decimal(10, 2) NOT NULL DEFAULT '0.00' COMMENT '退款扣除的手续费金额' after price_refund;

