package com.liquidnet.service.base;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.ServletUtils;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class UserPathDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -4153353929914805750L;
    private static final String LOG_SEPARATOR = ",";
    private static final String LOG_NOW_ELK = "NOW_ELK_";
    private static final String LOG_NOW_PDK = "NOW_PDK_";
    private static UserPathDto instance = new UserPathDto();

    //    private String tag;
    private String uid;
    private String ip;
    private String token;
    private LocalDateTime time;
    private String interfaceName;
    private Object params;
    private Object result;
    private String userAgent;

    private UserPathDto() {
    }

    private static UserPathDto getInstance() {
        try {
            return (UserPathDto) instance.clone();
        } catch (CloneNotSupportedException e) {
            return new UserPathDto();
        }
    }

    /*public static String setData(String interfaceName, Object params, Object result) {
//        instance.tag = "MDSKY.NOW.ELK";
        instance.ip = CurrentUtil.getCliIpAddr();
        instance.uid = CurrentUtil.getCurrentUid() == null ? "UID" : CurrentUtil.getCurrentUid();
        instance.token = CurrentUtil.getToken() == null ? "TOKEN" : CurrentUtil.getToken();
        instance.time = DateUtil.Formatter.yyyyMMddHHmmssSSSUnTrim.format(LocalDateTime.now());
        instance.interfaceName = interfaceName;
        instance.params = params.toString().equals("") ? "NanParams" : params.toString();
        instance.result = result.toString().equals("") ? "NanResults" : result.toString();
        instance.userAgent = ServletUtils.getRequest().getHeader("User-Agent");
        return "MDSKY.NOW.ELK." + ( instance.uid.equals("UID") ? CurrentUtil.getCliIpAddr() :  instance.uid )+ " = " + JsonUtils.toJson(instance);
    }

    public static String setPartnerData(String merchantId ,String interfaceName, Object params, Object result) {
        instance.ip = CurrentUtil.getCliIpAddr();
        instance.uid = merchantId;
        instance.time = LocalDateTime.now();
        instance.interfaceName = interfaceName;
        instance.params = params.toString().equals("") ? "NanParams" : params.toString();
        instance.result = result.toString().equals("") ? "NanResults" : result.toString();
        instance.userAgent = ServletUtils.getRequest().getHeader("User-Agent");
        return "MDSKY.NOW.PDK." + instance.uid+ " = " + JsonUtils.toJson(instance);
    }*/

    public static String setData(String interfaceName, Object params, Object result) {
        HttpServletRequest request = ServletUtils.getRequest();
        String uid = (String) request.getAttribute(CurrentUtil.TOKEN_SUB);

        UserPathDto userPathDto = getInstance();
        userPathDto.setIp(CurrentUtil.getCliIpAddr());
        userPathDto.setUid(uid);
        userPathDto.setToken((String) request.getAttribute(CurrentUtil.uToken));
        userPathDto.setTime(LocalDateTime.now());
        userPathDto.setInterfaceName(interfaceName);
        userPathDto.setParams(params);
        userPathDto.setResult(result);
        userPathDto.setUserAgent(request.getHeader(ServletUtils.HEADER_USER_AGENT));

        return (LOG_NOW_ELK + (StringUtils.isEmpty(uid) ? interfaceName : uid)).concat(LOG_SEPARATOR)
                .concat(JsonUtils.toJson(userPathDto));
    }

    public static String setPartnerData(String merchantId, String interfaceName, Object params, Object result) {
        HttpServletRequest request = ServletUtils.getRequest();

        UserPathDto userPathDto = getInstance();
        userPathDto.setIp(CurrentUtil.getCliIpAddr());
        userPathDto.setUid(merchantId);
        userPathDto.setTime(LocalDateTime.now());
        userPathDto.setInterfaceName(interfaceName);
        userPathDto.setParams(params);
        userPathDto.setResult(result);
        userPathDto.setUserAgent(request.getHeader(ServletUtils.HEADER_USER_AGENT));

        return (LOG_NOW_PDK + merchantId).concat(LOG_SEPARATOR).concat(JsonUtils.toJson(instance));
    }
}
