package com.liquidnet.service.goblin.param;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@ApiModel(value = "GoblinBraceletOrderPayParam", description = "手环下单请求参数")
@Data
public class GoblinBraceletOrderPayParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "手环ID")
    @NotBlank(message = "wristbandId不能为空")
    private String wristbandId;

    @ApiModelProperty(value = "金额ID")
    @NotBlank(message = "金额ID不能为空")
    private String amountId;

    @ApiModelProperty(value = "姓名")
    @NotBlank(message = "绑定姓名不能为空")
    private String name;

    @ApiModelProperty(value = "手机号")
    @NotBlank(message = "绑定手机号不能为空")
    private String mobile;

    @ApiModelProperty(value = "身份证号码")
    @NotBlank(message = "绑定身份证号码不能为空")
    private String idCard;

    @ApiModelProperty(value = "子商户用户标识")
    @NotBlank(message = "openId不能为空")
    private String subOpenId;
}
