package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel
@Data
public class GoblinStoreOrderListVo implements Cloneable {
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "订单号")
    private String orderCode;
    @ApiModelProperty(value = "下单时间")
    private String createdAt;
    @ApiModelProperty(value = " 支付类型[wepay-微信支付|alipay-阿里支付|douyinpay-抖音支付|unionpay-银联支付]")
    private String payType;
    @ApiModelProperty(value = " 收货人姓名")
    private String expressContacts;
    @ApiModelProperty(value = " 收货人联系方式")
    private String expressPhone;
    @ApiModelProperty(value = " 收货人地址")
    private String expressAddressDetail;
    @ApiModelProperty(value = " 收货人省市县")
    private String expressAddress;

    @ApiModelProperty(value = " 平台券id")
    private String platformUcouponId;
    @ApiModelProperty(value = " 平台券名称")
    private String platformUcouponName;
    @ApiModelProperty(value = " 店铺券id")
    private String storeUcouponId;
    @ApiModelProperty(value = " 店铺券名称")
    private String storeUcouponName;

    @ApiModelProperty(value = " 付款金额")
    private BigDecimal priceActual;
    @ApiModelProperty(value = " 快递费")
    private BigDecimal priceExpress;
    @ApiModelProperty(value = " 订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)]")
    private Integer status;
    @ApiModelProperty(value = " 付款时间")
    private String payTime;
    @ApiModelProperty(value = " 物流公司姓名")
    private String logisticsCompany;
    @ApiModelProperty(value = " 活动名称")
    private String marketName;
    @ApiModelProperty(value = " 物流相关")
    private List<GoblinMailVo> goblinMailVoList;
    //todo hujiachen 缺发货时间
    @ApiModelProperty(value = " sku相关")
    private List<GoblinStoreOrderListSkuVo> storeOrderListSkuVoList;


    private static final GoblinStoreOrderListVo obj = new GoblinStoreOrderListVo();

    public static GoblinStoreOrderListVo getNew() {
        try {
            return (GoblinStoreOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreOrderListVo();
        }
    }
}
