package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: nft转让信息查询
 * @class: GalaxyQueryNftInfoReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryTransNftInfoReqDto", description = "nft转让信息查询")
@Data
public class GalaxyQueryTransNftInfoReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable{
    @ApiModelProperty(position = 1, required = true, value = "NFTId")
    @NotBlank
    private String nftId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryTransNftInfoReqDto obj = new GalaxyQueryTransNftInfoReqDto();

    public static GalaxyQueryTransNftInfoReqDto getNew() {
        try {
            return (GalaxyQueryTransNftInfoReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryTransNftInfoReqDto();
        }
    }
}
