package com.liquidnet.common.third.zxlnft.biz;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.wallet.GenerateApiSignReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.GenerateApiSignResp;
import com.liquidnet.common.third.zxlnft.dto.wallet.SignByPriKeyReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.SignByPriKeyResp;
import com.liquidnet.common.third.zxlnft.exception.ZxlNftException;
import com.liquidnet.common.third.zxlnft.service.WalletSdkService;
import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlnftBiz
 * @Package com.liquidnet.common.third.zxlnft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/21 11:19
 */
@Slf4j
@Component
public class ZxlnftBiz {
    @Autowired
    private ZxlnftConfig zxlnftConfig;
    @Autowired
    private WalletSdkService walletSdkService;

    /**
     * 构造鉴权方案二
     * @param commonHeader
     */
    public void buildHeader(MultiValueMap<String, String> commonHeader){
        GenerateApiSignReq req = GenerateApiSignReq.getNew();
        req.setAppId("");
        req.setAppKey("");
        GenerateApiSignResp resp = walletSdkService.generateApiSign(req);

        commonHeader.clear();
        commonHeader.add("Signature", resp.getSignData().getSignature());
        commonHeader.add("Signature-Time", resp.getSignData().getSignatureTime());
        commonHeader.add("Nonce", resp.getSignData().getNonce());
        commonHeader.add("Content-Type", "application/json;charset=utf-8");

        log.info("buildHeader ---> {}",JsonUtils.toJson(commonHeader));
    }

    /**
     * 构造鉴权方案一
     * @param commonHeader
     */
    public void buildPlatFormHeader(MultiValueMap<String, String> commonHeader){
        GenerateApiSignReq req = GenerateApiSignReq.getNew();
        req.setAppId(zxlnftConfig.getAppId());
        req.setAppKey(zxlnftConfig.getAppKey());
        GenerateApiSignResp resp = walletSdkService.generateApiSign(req);

        commonHeader.clear();
        commonHeader.add("App-Id", req.getAppId());
        commonHeader.add("Signature", resp.getSignData().getSignature());
        commonHeader.add("Signature-Time", resp.getSignData().getSignatureTime());
        commonHeader.add("Nonce", resp.getSignData().getNonce());
        commonHeader.add("Content-Type", "application/json;charset=utf-8");

        log.info("buildPlatFormHeader ---> {}",JsonUtils.toJson(commonHeader));
    }

    public static <T> T buildNftRespObj(String response,Class<T> tClass){
        T resp = null;
        try {
            resp = tClass.newInstance();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        JSONObject json = JSONObject.parseObject(response);
        if (json.containsKey("retCode") && json.containsKey("data") && json.getInteger("retCode").intValue() == 0) {
            JSONObject data = json.getJSONObject("data");
            resp = JsonUtils.fromJson(data.toJSONString(),tClass);
        }else {
            if (json.containsKey("retCode") && json.getInteger("retCode").intValue() != 0) {
                throw new ZxlNftException(String.valueOf(json.getInteger("retCode")), json.getString("retMsg"));
            }
            throw new ZxlNftException(json.getString("retCode"), json.getString("retMsg"));
        }
        return resp;
    }

    /**
     * 接口内签名
     * @param key
     * @param data
     * @return
     */
    public String createSign(String key,String data){
        SignByPriKeyReq req = SignByPriKeyReq.getNew();
        req.setPriKey(key);
        req.setData(data);
        SignByPriKeyResp resp = walletSdkService.signByPriKey(req);
        return resp.getSignedData();
    }
}
