package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.File;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 5.营业执照上传（使用nft平台签名）接口
 * @class: BusinessLicenseUploadPlatformReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:23
 */
@Data
public class Nft005BusinessLicenseUploadPlatformReq implements Serializable {
    /**
     * 营业执照图片，不超过5M，jpg或png格式
     */
    private File file;

    /**
     * 平台的"用户唯一标识"
     */
    private String platformIdentification;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 平台签名信
     */
    private String platformSignData;

    private static final Nft005BusinessLicenseUploadPlatformReq obj = new Nft005BusinessLicenseUploadPlatformReq();
    private static final long serialVersionUID = 5717489720702326452L;

    public static Nft005BusinessLicenseUploadPlatformReq getNew() {
        try {
            return (Nft005BusinessLicenseUploadPlatformReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft005BusinessLicenseUploadPlatformReq();
        }
    }
}
