package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 10.企业注册实名（使用nft平台签名）接口
 * @class: RegisterCompanyPlatformReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:27
 */
@Data
public class Nft010RegisterCompanyPlatformReq implements Serializable {
    /**
     * 企业名称
     */
    private String epName;
    /**
     * 企业邮箱
     */
    private String email;
    /**
     * 企业信用代码
     */
    private String creditCode;
    /**
     * 营业执照文件标识，通过调用上传接口后获得
     */
    private int busiLicenseId;
    /**
     * 电子公函盖章扫描件标识，通过调用上传接口后获得
     */
    private int officialLetterId;
    /**
     * 法人代表姓名
     */
    private String representativeName;
    /**
     * 管理员姓名
     */
    private String contact;
    /**
     * 管理员手机
     */
    private String mobile;
    /**
     * 管理员身份证号
     */
    private String idcard;
    /**
     * 证件类型 1-身份证 2-护照 3-港澳通行证 4-台湾通行证 5-外国人永居身份证 6-港澳台居民居住证 7-其它
     */
    private int cardType;
    /**
     * 接入平台名称
     */
    private String platformName;
    /**
     * 接入平台地址
     */
    private String platformUrl;
    /**
     * 平台业务类型（1:金融类 2:版权类 3:其他类 4:未填写）默认是未填写
     */
    private int businessType;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 平台签名信息:sign(epName_creditCode_representativeName_contact_mobile_idcard)
     */
    private String platformSignData;

    private static final Nft010RegisterCompanyPlatformReq obj = new Nft010RegisterCompanyPlatformReq();
    private static final long serialVersionUID = 421494805622599134L;

    public static Nft010RegisterCompanyPlatformReq getNew() {
        try {
            return (Nft010RegisterCompanyPlatformReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft010RegisterCompanyPlatformReq();
        }
    }
}
