package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 30.NFT 系列声明
 * @class: SeriesClaimReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:43
 */
@Data
public class Nft030SeriesClaimReq implements Serializable {
    /**
     * 系列声明人公钥
     */
    private String pubKey;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 系列名，不超过30个字符
     */
    private String seriesName;
    /**
     * 系列一共有多少个，0表示没有限制
     */
    private Long totalCount;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的ID
     */
    private String operateId;
    /**
     * 系列封面url，不超过1024个字符
     */
    private String coverUrl;
    /**
     * 系列描述信息，不超过500个字符
     */
    private String desc;
    /**
     * 历史遗留字段，无意义，填任意值都一样，建议填0即可
     */
    private String maxPublishCount;
    /**
     * 系列下的nftId后缀，是否从0开始，true就是从0开始，默认为false,从1开始
     */
    private String seriesBeginFromZero;
    /**
     * 系列声明人的私钥签名，签名对象是（platformPubKey_pubKey_接口名_seriesName_totalCount_coverUrl_desc_maxPublishCount
     * _seriesBeginFromZero_operateId） 接口名：series_claim
     */
    private String signature;
    /**
     * 平台方的私钥签名，签名对象和signature对象一致
     */
    private String platformSignature;
    private static final Nft030SeriesClaimReq obj = new Nft030SeriesClaimReq();
    private static final long serialVersionUID = 8038815208509230362L;

    public static Nft030SeriesClaimReq getNew() {
        try {
            return (Nft030SeriesClaimReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft030SeriesClaimReq();
        }
    }
}
