package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 42.通过地址查询全部NFT交易信息列表 GET请求方式
 * @class: TradeAllListReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:51
 */
@Data
public class Nft042TradeAllListReq implements Serializable {
    /**
     * 账户地址
     */
    private String addr;
    /**
     * 查询偏移量，从0开始，和mysql一个语义
     */
    private Long offset;
    /**
     * 最大1000
     */
    private Long limit;
    private static final Nft042TradeAllListReq obj = new Nft042TradeAllListReq();
    private static final long serialVersionUID = 3659452223931148023L;

    public static Nft042TradeAllListReq getNew() {
        try {
            return (Nft042TradeAllListReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft042TradeAllListReq();
        }
    }
}
