/*     */ package com.liquidnet.common.third.zxlnft.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftConstant;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.wallet.*;
import com.liquidnet.common.third.zxlnft.service.WalletSdkService;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

@Slf4j
@Service
public class WalletSdkServiceImpl implements WalletSdkService {

  @Autowired
  private ZxlnftConfig zxlnftConfig;

  private static MultiValueMap<String, String> commonHeader = new LinkedMultiValueMap();
  private static MultiValueMap<String, String> commonParams = new LinkedMultiValueMap();

  @Override
  public CreateMnemonicResp createMnemonic(CreateMnemonicReq req) {
    JSONObject json = new JSONObject();

    String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_01_CREATE_MNEMONIC;
    log.info("createMnemonic--->>> request url : {}  body : {} ",requestUrl, json.toString());

    String response = null;
    try {
      response = HttpUtil.postJson(requestUrl,json.toString());
    } catch(HttpClientErrorException e) {
      log.error("createMnemonic error", e);
      if(e.getRawStatusCode() == 400){
        JSONObject jsonObject = JsonUtils.fromJson(e.getResponseBodyAsString(), new TypeReference<JSONObject>() {});
        return null;
      }
    }catch (Exception e) {
      log.error("createUser error",e);
    }
    log.info("createMnemonic--->>> response : {} ",response);

    if (StringUtils.isEmpty(response)) {
      return null;
    }
    CreateMnemonicResp resp = JsonUtils.fromJson(response,CreateMnemonicResp.class);
    return resp;
  }

  @Override
  public GenerateApiSignResp generateApiSign(GenerateApiSignReq req) {
    JSONObject json = new JSONObject();
    json.put("appId", req.getAppId());
    json.put("appKey", req.getAppKey());

    String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_02_GENERATE_API_SIGN;
    log.info("generateApiSign--->>> request url : {}  body : {} ",requestUrl, json.toString());

    String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
    try {
      response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
    } catch(HttpClientErrorException e) {
      log.error("generateApiSign error", e);
    }catch (Exception e) {
      log.error("generateApiSign error",e);
    }
    log.info("generateApiSign--->>> response : {} ",response);

    if (StringUtils.isEmpty(response)) {
      return null;
    }
    GenerateApiSignResp resp = JsonUtils.fromJson(response,GenerateApiSignResp.class);
    return resp;
  }

  @Override
  public UploadToCosResp uploadToCos(UploadToCosReq req) {
      JSONObject json = new JSONObject();
      json.put("cosPath", req.getCosPath());
      json.put("tempSecretId", req.getTempSecretId());
      json.put("tempSecretKey", req.getTempSecretKey());
      json.put("sessionToken", req.getSessionToken());
      json.put("filePath", req.getFilePath());

      String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_03_UPLOAD_TO_COS;
      log.info("uploadToCos--->>> request url : {}  body : {} ",requestUrl, json.toString());

      String response = null;
      //        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
      try {
          response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
      } catch(HttpClientErrorException e) {
          log.error("uploadToCos error", e);
      }catch (Exception e) {
          log.error("uploadToCos error",e);
      }
      log.info("uploadToCos--->>> response : {} ",response);

      if (StringUtils.isEmpty(response)) {
          return null;
      }
      UploadToCosResp resp = JsonUtils.fromJson(response,UploadToCosResp.class);
      return resp;
  }

  @Override
  public UploadFileToCosResp uploadFileToCos(UploadFileToCosReq req) {
    return null;
  }

  @Override
  public DeriveKeyPairResp deriveKeyPair(DeriveKeyPairReq req) {
      JSONObject json = new JSONObject();
      json.put("mnemonic", req.getMnemonic());
      json.put("index", req.getIndex());

      String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_05_DERIVE_KEY_PAIR;
      log.info("deriveKeyPair--->>> request url : {}  body : {} ",requestUrl, json.toString());

      String response = null;
      //        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
      try {
          response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
      } catch(HttpClientErrorException e) {
          log.error("deriveKeyPair error", e);
      }catch (Exception e) {
          log.error("deriveKeyPair error",e);
      }
      log.info("deriveKeyPair--->>> response : {} ",response);

      if (StringUtils.isEmpty(response)) {
          return null;
      }
      DeriveKeyPairResp resp = JsonUtils.fromJson(response,DeriveKeyPairResp.class);
      return resp;
  }

  @Override
  public SignByPriKeyResp signByPriKey(SignByPriKeyReq req) {
      JSONObject json = new JSONObject();
      json.put("priKey", req.getPriKey());
      json.put("data", req.getData());

      String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_06_SIGN_BY_PRI_KEY;
      log.info("signByPriKey--->>> request url : {}  body : {} ",requestUrl, json.toString());

      String response = null;
  //        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
      try {
        response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
      } catch(HttpClientErrorException e) {
        log.error("signByPriKey error", e);
      }catch (Exception e) {
        log.error("signByPriKey error",e);
      }
      log.info("signByPriKey--->>> response : {} ",response);

      if (StringUtils.isEmpty(response)) {
        return null;
      }
      SignByPriKeyResp resp = JsonUtils.fromJson(response,SignByPriKeyResp.class);
      return resp;
  }

  @Override
  public PriKey2PubKeyResp priKey2PubKey(PriKey2PubKeyReq req) {
    return null;
  }

  @Override
  public PubKey2AddressResp pubKey2Address(PubKey2AddressReq req) {
    return null;
  }

  @Override
  public PriKey2AddressResp priKey2Address(PriKey2AddressReq req) {
    return null;
  }

  @Override
  public VerifyByPubKeyResp verifyByPubKey(VerifyByPubKeyReq req) {
      JSONObject json = new JSONObject();
      json.put("pubKey", req.getPubKey());
      json.put("signedData", req.getSignedData());
      json.put("data", req.getData());

      String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_10_VERIFY_BY_PUB_KEY;
      log.info("verifyByPubKey--->>> request url : {}  body : {} ",requestUrl, json.toString());

      String response = null;
      try {
        response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
      } catch(HttpClientErrorException e) {
        log.error("verifyByPubKey error", e);
      }catch (Exception e) {
        log.error("verifyByPubKey error",e);
      }
      log.info("verifyByPubKey--->>> response : {} ",response);

      if (StringUtils.isEmpty(response)) {
        return null;
      }
      VerifyByPubKeyResp resp = JsonUtils.fromJson(response,VerifyByPubKeyResp.class);
      return resp;
  }

  @Override
  public SM3HashResp sM3Hash(SM3HashReq req) {
    return null;
  }

  @Override
  public SM3HashEncodeResp sM3HashEncode(SM3HashEncodeReq req) {
    return null;
  }
}