package com.liquidnet.common.third.zxlnft.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftConstant;
import com.liquidnet.common.third.zxlnft.dto.nft.*;
import com.liquidnet.common.third.zxlnft.service.ZxlnftSdkService;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class ZxlnftSdkServiceImpl implements ZxlnftSdkService
{
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    private MultiValueMap<String, String> commonHeader = new LinkedMultiValueMap();

//    @Override
//    public Nft001RegisterVerifyCodeResp nft001RegisterVerifyCode(Nft001RegisterVerifyCodeReq req) {
//        zxlnftBiz.buildHeader(commonHeader);
//
//        JSONObject json = new JSONObject();
//        json.put("mobile", req.get);
//        json.put("apKey", req.getAppKey());
//
//        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_016_IDENTITY_BIND_QUERY_URL;
//        log.info("nft001RegisterVerifyCode--->>> request url : {}  body : {} ",requestUrl, params.toString());
//
//        String response = null;
////        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
//        try {
//            response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
//        } catch(HttpClientErrorException e) {
//            log.error("nft001RegisterVerifyCode error", e);
//        }catch (Exception e) {
//            log.error("nft001RegisterVerifyCode error",e);
//        }
//        log.info("nft001RegisterVerifyCode--->>> response : {} ",response);
//
//        if (StringUtils.isEmpty(response)) {
//            return null;
//        }
//
//        Nft001RegisterVerifyCodeResp resp = Nft001RegisterVerifyCodeResp.getNew();
//        JSONObject json = JSONObject.parseObject(response);
//        if (json.containsKey("retCode") && json.containsKey("data") && json.getInteger("retCode").intValue() == 0) {
//            JSONObject data = json.getJSONObject("data");
//            resp = JsonUtils.fromJson(data.toJSONString(),Nft001RegisterVerifyCodeResp.class);
//        }else {
//            if (json.containsKey("retCode") && json.getInteger("retCode").intValue() != 0) {
//                throw new ZxlNftException(String.valueOf(json.getInteger("retCode")), json.getString("retMsg") + ", address:" + req.getAddressList());
//            }
//            throw new ZxlNftException(json.getString("retCode"), json.getString("retMsg") + ", address:" + req.getAddressList());
//        }
//
//        log.info("nft001RegisterVerifyCode--->>> return result : {} ",resp.toString());
//        return resp;
//    }

    @Override
    public Nft001RegisterVerifyCodeResp nft001RegisterVerifyCode(Nft001RegisterVerifyCodeReq req) {
        return null;
    }

    @Override
    public Nft002RegisterPersonResp nft002RegisterPerson(Nft002RegisterPersonReq req) {
        return null;
    }

    @Override
    public Nft003RegisterPersonPlatformResp nft003RegisterPersonPlatform(Nft003RegisterPersonPlatformReq req) {
        return null;
    }

    @Override
    public Nft004BusinessLicenseUploadResp nft004BusinessLicenseUpload(Nft004BusinessLicenseUploadReq req) {
        return null;
    }

    @Override
    public Nft005BusinessLicenseUploadPlatformResp nft005BusinessLicenseUploadPlatform(Nft005BusinessLicenseUploadPlatformReq req) {
        return null;
    }

    @Override
    public Nft006OfficialLetterUploadResp nft006OfficialLetterUpload(Nft006OfficialLetterUploadReq req) {
        return null;
    }

    @Override
    public Nft007OfficialLetterUploadPlatformResp nft007OfficialLetterUploadPlatform(Nft007OfficialLetterUploadPlatformReq req) {
        return null;
    }

    @Override
    public Nft008QueryImageModerationResp nft008QueryImageModeration(Nft008QueryImageModerationReq req) {
        return null;
    }

    @Override
    public Nft009RegisterCompanyResp nft009RegisterCompany(Nft009RegisterCompanyReq req) {
        return null;
    }

    @Override
    public Nft010RegisterCompanyPlatformResp nft010RegisterCompanyPlatform(Nft010RegisterCompanyPlatformReq req) {
        return null;
    }

    @Override
    public Nft011UserQueryVerifyCodeResp nft011UserQueryVerifyCode(Nft011UserQueryVerifyCodeReq req) {
        return null;
    }

    @Override
    public Nft012UserQueryResp nft012UserQuery(Nft012UserQueryReq req) {
        return null;
    }

    @Override
    public Nft013IdentityBindSubmitResp nft013IdentityBindSubmit(Nft013IdentityBindSubmitReq req) {
        return null;
    }

    @Override
    public Nft014IdentityBindSubmitByTrustedResp nft014IdentityBindSubmitByTrusted(Nft014IdentityBindSubmitByTrustedReq req) {
        return null;
    }

    @Override
    public Nft015IdentityBindPlatformSelfResp nft015IdentityBindPlatformSelf(Nft015IdentityBindPlatformSelfReq req) {
        return null;
    }

    @Override
    public Nft016IdentityBindQueryResp nft016IdentityBindQuery(Nft016IdentityBindQueryReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        MultiValueMap<String, Object> params = new LinkedMultiValueMap();
        List<String> addressList = new ArrayList();
        addressList.add(req.getAddressList());
        params.add("addressList", addressList);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_016_IDENTITY_BIND_QUERY_URL;
        log.info("nft016IdentityBindQuery--->>> request url : {}  body : {} ",requestUrl, params.toString());

        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.get(requestUrl+"?addressList="+req.getAddressList(),null,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft016IdentityBindQuery error", e);
        }catch (Exception e) {
            log.error("nft016IdentityBindQuery error",e);
        }
        log.info("nft016IdentityBindQuery--->>> response : {} ",response);

        if (StringUtils.isEmpty(response)) {
            return null;
        }

//        Nft016IdentityBindQueryResp resp = Nft016IdentityBindQueryResp.getNew();
//         JSONObject json = JSONObject.parseObject(response);
//         if (json.containsKey("retCode") && json.containsKey("data") && json.getInteger("retCode").intValue() == 0) {
//             JSONObject data = json.getJSONObject("data");
//             resp = JsonUtils.fromJson(data.toJSONString(),Nft016IdentityBindQueryResp.class);
//         }else {
//             if (json.containsKey("retCode") && json.getInteger("retCode").intValue() != 0) {
//                 throw new ZxlNftException(String.valueOf(json.getInteger("retCode")), json.getString("retMsg") + ", address:" + req.getAddressList());
//             }
//             throw new ZxlNftException(json.getString("retCode"), json.getString("retMsg") + ", address:" + req.getAddressList());
//         }
        /**
         * 构造返回结果
         */
        Nft016IdentityBindQueryResp resp = zxlnftBiz.buildNftRespObj(response,Nft016IdentityBindQueryResp.class);

        log.info("nft016IdentityBindQuery--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft017IdentityVerifyIdentityResp nft017IdentityVerifyIdentity(Nft017IdentityVerifyIdentityReq req) {
        return null;
    }

    @Override
    public Nft018FaceUrlResp nft018FaceUrl(Nft018FaceUrlReq req) {
        return null;
    }

    @Override
    public Nft019FaceUrlByAddressResp nft019FaceUrlByAddress(Nft019FaceUrlByAddressReq req) {
        return null;
    }

    @Override
    public Nft020FaceQueryResp nft020FaceQuery(Nft020FaceQueryReq req) {
        return null;
    }

    @Override
    public Nft021UploadUrlResp nft021UploadUrl(Nft021UploadUrlReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        List<NameValuePair> params = new ArrayList<NameValuePair>();
        if(StringUtil.isNotEmpty(req.getSeriesName())){
            params.add(new BasicNameValuePair("seriesName", req.getSeriesName()));
        }
        params.add(new BasicNameValuePair("platformIdentification", req.getPlatformIdentification()));
        if(StringUtil.isNotEmpty(req.getUserIdentification())){
            params.add(new BasicNameValuePair("userIdentification", req.getUserIdentification()));
        }

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_021_UPLOAD_URL_URL;
        log.info("nft021UploadUrl--->>> request url : {}  body : {} ",requestUrl, params.toString());

        //拼接请求url
        URI build = null;
        try {
            build = new URIBuilder(requestUrl).addParameters(params).build();
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        requestUrl = build.toString();

        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.get(requestUrl,null,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft021UploadUrl error", e);
        }catch (Exception e) {
            log.error("nft021UploadUrl error",e);
        }
        log.info("nft021UploadUrl--->>> response : {} ",response);

        if (StringUtils.isEmpty(response)) {
            return null;
        }

//        Nft016IdentityBindQueryResp resp = Nft016IdentityBindQueryResp.getNew();
//         JSONObject json = JSONObject.parseObject(response);
//         if (json.containsKey("retCode") && json.containsKey("data") && json.getInteger("retCode").intValue() == 0) {
//             JSONObject data = json.getJSONObject("data");
//             resp = JsonUtils.fromJson(data.toJSONString(),Nft016IdentityBindQueryResp.class);
//         }else {
//             if (json.containsKey("retCode") && json.getInteger("retCode").intValue() != 0) {
//                 throw new ZxlNftException(String.valueOf(json.getInteger("retCode")), json.getString("retMsg") + ", address:" + req.getAddressList());
//             }
//             throw new ZxlNftException(json.getString("retCode"), json.getString("retMsg") + ", address:" + req.getAddressList());
//         }
        /**
         * 构造返回结果
         */
        Nft021UploadUrlResp resp = zxlnftBiz.buildNftRespObj(response,Nft021UploadUrlResp.class);

        log.info("nft021UploadUrl--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft022UploadSecretResp nft022UploadSecret(Nft022UploadSecretReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

//        MultiValueMap<String, Object> params = new LinkedMultiValueMap();
//        List<String> addressList = new ArrayList();
//        if(StringUtil.isNotEmpty(req.getSeriesName())){
//            params.add("seriesName", req.getSeriesName());
//        }
//        params.add("tiemstamp", req.getTiemstamp());
//        params.add("pubKey", req.getPubKey());
//        params.add("pubSignedData", req.getPubSignedData());
//        params.add("userPubKey", req.getUserPubKey());
//        params.add("userSignedData", req.getUserSignedData());

        JSONObject json = new JSONObject();
        if(StringUtil.isNotEmpty(req.getSeriesName())){
            json.put("seriesName", req.getSeriesName());
        }
        json.put("timestamp", req.getTimestamp());
        json.put("pubKey", req.getPubKey());
        json.put("pubSignedData", req.getPubSignedData());
        json.put("userPubKey", req.getUserPubKey());
        json.put("userSignedData", req.getUserSignedData());

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_022_UPLOAD_SECRET_URL;
        log.info("nft022UploadSecret--->>> request url : {}  body : {} ",requestUrl,json.toString());

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft022UploadSecret error", e);
        }catch (Exception e) {
            log.error("nft022UploadSecret error",e);
        }
        log.info("nft022UploadSecret--->>> response : {} ",response);

        if (StringUtils.isEmpty(response)) {
            return null;
        }

        /**
         * 构造返回结果
         */
        Nft022UploadSecretResp resp = zxlnftBiz.buildNftRespObj(response,Nft022UploadSecretResp.class);
        log.info("nft022UploadSecret--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft023PointApplyResp nft023PointApply(Nft023PointApplyReq req) {
        return null;
    }

    @Override
    public Nft024PointApplyResultResp nft024PointApplyResult(Nft024PointApplyResultReq req) {
        return null;
    }

    @Override
    public Nft025PointTransferResp nft025PointTransfer(Nft025PointTransferReq req) {
        return null;
    }

    @Override
    public Nft026PointTransferResultResp nft026PointTransferResult(Nft026PointTransferResultReq req) {
        return null;
    }

    @Override
    public Nft027PointDestroyResp nft027PointDestroy(Nft027PointDestroyReq req) {
        return null;
    }

    @Override
    public Nft028PointDestoryResultResp nft028PointDestoryResult(Nft028PointDestoryResultReq req) {
        return null;
    }

    @Override
    public Nft029PointQueryResp nft029PointQuery(Nft029PointQueryReq req) {
        return null;
    }

    @Override
    public Nft030SeriesClaimResp nft030SeriesClaim(Nft030SeriesClaimReq req) {
        return null;
    }

    @Override
    public Nft031SeriesClaimResultResp nft031SeriesClaimResult(Nft031SeriesClaimResultReq req) {
        return null;
    }

    @Override
    public Nft032SeriesResp nft032Series(Nft032SeriesReq req) {
        return null;
    }

    @Override
    public Nft033SeriesListResp nft033SeriesList(Nft033SeriesListReq req) {
        return null;
    }

    @Override
    public Nft034PublishResp nft034Publish(Nft034PublishReq req) {
        return null;
    }

    @Override
    public Nft035PublishResultResp nft035PublishResult(Nft035PublishResultReq req) {
        return null;
    }

    @Override
    public Nft036InfoResp nft036Info(Nft036InfoReq req) {
        return null;
    }

    @Override
    public Nft037AddressListResp nft037AddressList(Nft037AddressListReq req) {
        return null;
    }

    @Override
    public Nft038AddressWithoutSeriesListResp nft038AddressWithoutSeriesList(Nft038AddressWithoutSeriesListReq req) {
        return null;
    }

    @Override
    public Nft039TradeListResp nft039TradeList(Nft039TradeListReq req) {
        return null;
    }

    @Override
    public Nft040TradeInListResp nft040TradeInList(Nft040TradeInListReq req) {
        return null;
    }

    @Override
    public Nft041TradeOutListResp nft041TradeOutList(Nft041TradeOutListReq req) {
        return null;
    }

    @Override
    public Nft042TradeAllListResp nft042TradeAllList(Nft042TradeAllListReq req) {
        return null;
    }

    @Override
    public Nft043BuyResp nft043Buy(Nft043BuyReq req) {
        return null;
    }

    @Override
    public Nft044BuyResultResp nft044BuyResult(Nft044BuyResultReq req) {
        return null;
    }

    @Override
    public Nft045BuyPayResultResp nft045BuyPayResult(Nft045BuyPayResultReq req) {
        return null;
    }

    @Override
    public Nft046TransferResp nft046Transfer(Nft046TransferReq req) {
        return null;
    }

    @Override
    public Nft047SelfTransferResp nft047SelfTransfer(Nft047SelfTransferReq req) {
        return null;
    }

    @Override
    public Nft048BatchTransferResp nft048BatchTransfer(Nft048BatchTransferReq req) {
        return null;
    }

    @Override
    public Nft049TransferResultResp nft049TransferResult(Nft049TransferResultReq req) {
        return null;
    }

    @Override
    public Nft050StatusUpdateResp nft050StatusUpdate(Nft050StatusUpdateReq req) {
        return null;
    }

    @Override
    public Nft051StatusUpdateResultResp nft051StatusUpdateResult(Nft051StatusUpdateResultReq req) {
        return null;
    }

    @Override
    public Nft052PriceUpdateResp nft052PriceUpdate(Nft052PriceUpdateReq req) {
        return null;
    }

    @Override
    public Nft053PriceUpdateResultResp nft053PriceUpdateResult(Nft053PriceUpdateResultReq req) {
        return null;
    }

    @Override
    public Nft054QueryUserAddressBelongToUserResp nft054QueryUserAddressBelongToUser(Nft054QueryUserAddressBelongToUserReq req) {
        return null;
    }
}