package com.liquidnet.common.third.zxlnft.util;

import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.nft.*;
import com.liquidnet.common.third.zxlnft.service.ZxlnftSdkService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlnftSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.util
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/2/24 16:08
 */
@Slf4j
@Component
public class ZxlnftSdkUtil {
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private ZxlnftSdkService zxlnftSdkService;

    public Nft016IdentityBindQueryResp nft016IdentityBindQuery(Nft016IdentityBindQueryReq req){
        req.setAddressList(zxlnftConfig.getNftPlatformAddress());
        Nft016IdentityBindQueryResp resp = zxlnftSdkService.nft016IdentityBindQuery(req);
        return resp;
    }
    public Nft021UploadUrlResp nft021UploadUrl(Nft021UploadUrlReq req){
        Nft021UploadUrlResp resp = zxlnftSdkService.nft021UploadUrl(req);
        return resp;
    }
    public Nft022UploadSecretResp nft022UploadSecret(Nft022UploadSecretReq req){
        Nft022UploadSecretResp resp = zxlnftSdkService.nft022UploadSecret(req);
        return resp;
    }
}
