package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityPrizeRelationService;
import com.liquidnet.client.admin.zhengzai.sweet.utils.SweetObjectAdminUtil;
import com.liquidnet.client.admin.zhengzai.sweet.utils.SweetRedisAdminUtils;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.sweet.constant.StatusConst;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityPrizeRelationFormParam;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityPrizeRelationVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityPrizeVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrizeRelation;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityMapper;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityPrizeMapper;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityPrizeRelationMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 积分活动奖品里关联多奖品表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-12-02
 */
@Service
public class SweetIntegralActivityPrizeRelationServiceImpl extends ServiceImpl<SweetIntegralActivityPrizeRelationMapper, SweetIntegralActivityPrizeRelation> implements ISweetIntegralActivityPrizeRelationService {

    @Autowired
    private SweetIntegralActivityMapper sweetIntegralActivityMapper;
    @Autowired
    private SweetIntegralActivityPrizeMapper sweetIntegralActivityPrizeMapper;
    @Autowired
    private SweetIntegralActivityPrizeRelationMapper relationMapper;

    @Autowired
    private SweetRedisAdminUtils sweetRedisAdminUtils;

    @Override
    public Integer createForm(SweetIntegralActivityPrizeRelationFormParam param) {
        try {
            SweetIntegralActivityPrizeRelation prizeRelation = SweetIntegralActivityPrizeRelationFormParam.getNew().copy(param);
            String relationId = IDGenerator.nextSnowId();
            prizeRelation.setPrizeRelationId(relationId);
            int insert = relationMapper.insert(prizeRelation);
            // 活动redis处理
            this.integralActivityList(param.getIntegralActivityId());
            return insert;
        } catch (Exception e) {
            log.error("添加失败 [e:{}]", e);
            return 0;
        }
    }

    @Override
    public Integer delete(String prizeRelationId, String integralActivityId) {
        try {
            int delete = relationMapper.delete(
                    Wrappers.lambdaUpdate(SweetIntegralActivityPrizeRelation.class).eq(SweetIntegralActivityPrizeRelation::getPrizeRelationId, prizeRelationId)
            );
            // 活动redis处理
            this.integralActivityList(integralActivityId);
            return delete;
        } catch (Exception e) {
            log.error("删除失败 [e:{}]", e);
            return 0;
        }
    }

    @Override
    public List<SweetIntegralActivityPrizeRelation> list(String prizeId) {
        List<SweetIntegralActivityPrizeRelation> prizeRelations = relationMapper.selectList(
                Wrappers.lambdaQuery(SweetIntegralActivityPrizeRelation.class).eq(SweetIntegralActivityPrizeRelation::getPrizeId, prizeId)
        );
        return prizeRelations;
    }

    private void integralActivityList(String integralActivityId) {
        // 活动列表
        LambdaQueryWrapper<SweetIntegralActivity> queryWrapper = Wrappers.lambdaQuery(SweetIntegralActivity.class).eq(SweetIntegralActivity::getIsOnline, 2);
        LocalDateTime now = LocalDateTime.now();
        queryWrapper.eq(SweetIntegralActivity::getTimeType, 1).or().eq(SweetIntegralActivity::getIsOnline, 2).eq(SweetIntegralActivity::getTimeType, 2).gt(SweetIntegralActivity::getEndTime, now).lt(SweetIntegralActivity::getStartTime, now);
        List<SweetIntegralActivity> sweetIntegralActivities = sweetIntegralActivityMapper.selectList(queryWrapper);
        List<IntegralActivityVo> voList = SweetObjectAdminUtil.getSweetIntegralActivityVoList();
        sweetIntegralActivities.forEach(r -> {
            IntegralActivityVo copy = IntegralActivityVo.getNew().copy(r);
            voList.add(copy);
        });
        sweetRedisAdminUtils.setIntegralActivityList(voList);

        // 活动详情
        SweetIntegralActivity sweetIntegralActivity = sweetIntegralActivityMapper.selectOne(
                Wrappers.lambdaQuery(SweetIntegralActivity.class).eq(SweetIntegralActivity::getIntegralActivityId, integralActivityId)
        );
        IntegralActivityVo integralActivityVo = IntegralActivityVo.getNew().copy(sweetIntegralActivity);
        // 详情奖品 全部
        List<SweetIntegralActivityPrize> activityPrizes = sweetIntegralActivityPrizeMapper.selectList(
                Wrappers.lambdaQuery(SweetIntegralActivityPrize.class).eq(SweetIntegralActivityPrize::getIntegralActivityId, integralActivityId)
        );
        List<IntegralActivityPrizeVo> prizeList = SweetObjectAdminUtil.getSweetIntegralActivityPrizeVoList();
        activityPrizes.forEach(r -> {
            IntegralActivityPrizeVo copy = IntegralActivityPrizeVo.getNew().copy(r);
            // 奖品券列表
            List<SweetIntegralActivityPrizeRelation> prizeRelations = relationMapper.selectList(
                    Wrappers.lambdaQuery(SweetIntegralActivityPrizeRelation.class).eq(SweetIntegralActivityPrizeRelation::getPrizeId, copy.getPrizeId())
            );
            ArrayList<IntegralActivityPrizeRelationVo> prizeRelationVoList = SweetObjectAdminUtil.getSweetIntegralActivityPrizeRelationVoList();
            if (!CollectionUtils.isEmpty(prizeRelations)) {
                prizeRelations.forEach(rr -> {
                    IntegralActivityPrizeRelationVo copyR = IntegralActivityPrizeRelationVo.getNew().copy(rr);
                    prizeRelationVoList.add(copyR);
                });
            }
            copy.setPrizeRelationList(prizeRelationVoList);

            prizeList.add(copy);
        });
        integralActivityVo.setPrizeList(prizeList);
        // 详情奖品 积分和券
        List<SweetIntegralActivityPrize> activityPrizes1 = sweetIntegralActivityPrizeMapper.selectList(
                Wrappers.lambdaQuery(SweetIntegralActivityPrize.class).eq(SweetIntegralActivityPrize::getIntegralActivityId, integralActivityId)
                        .in(SweetIntegralActivityPrize::getPrizeType, Arrays.asList(StatusConst.PRIZE_TYPE1, StatusConst.PRIZE_TYPE2))
        );
        List<IntegralActivityPrizeVo> prizeList1 = SweetObjectAdminUtil.getSweetIntegralActivityPrizeVoList();
        activityPrizes1.forEach(r -> {
            IntegralActivityPrizeVo copy = IntegralActivityPrizeVo.getNew().copy(r);
            // 奖品券列表
            List<SweetIntegralActivityPrizeRelation> prizeRelations = relationMapper.selectList(
                    Wrappers.lambdaQuery(SweetIntegralActivityPrizeRelation.class).eq(SweetIntegralActivityPrizeRelation::getPrizeId, copy.getPrizeId())
            );
            ArrayList<IntegralActivityPrizeRelationVo> prizeRelationVoList = SweetObjectAdminUtil.getSweetIntegralActivityPrizeRelationVoList();
            if (!CollectionUtils.isEmpty(prizeRelations)) {
                prizeRelations.forEach(rr -> {
                    IntegralActivityPrizeRelationVo copyR = IntegralActivityPrizeRelationVo.getNew().copy(rr);
                    prizeRelationVoList.add(copyR);
                });
            }
            copy.setPrizeRelationList(prizeRelationVoList);

            prizeList1.add(copy);
        });
        integralActivityVo.setPrizeList1(prizeList1);
        // 详情奖品 实物等
        List<SweetIntegralActivityPrize> activityPrizes2 = sweetIntegralActivityPrizeMapper.selectList(
                Wrappers.lambdaQuery(SweetIntegralActivityPrize.class).eq(SweetIntegralActivityPrize::getIntegralActivityId, integralActivityId)
                        .in(SweetIntegralActivityPrize::getPrizeType, Arrays.asList(StatusConst.PRIZE_TYPE3, StatusConst.PRIZE_TYPE4, StatusConst.PRIZE_TYPE5))
        );
        List<IntegralActivityPrizeVo> prizeList2 = SweetObjectAdminUtil.getSweetIntegralActivityPrizeVoList();
        int totalPrizeNum = 0;
        for (SweetIntegralActivityPrize prize : activityPrizes2) {
            IntegralActivityPrizeVo copy = IntegralActivityPrizeVo.getNew().copy(prize);
            prizeList2.add(copy);
            int prizeNum = sweetRedisAdminUtils.getIntegralActivityPrizeNum(integralActivityId, prize.getPrizeId());
            totalPrizeNum += prizeNum;
        }
        sweetRedisAdminUtils.setIntegralActivityTotalPrizeNum(integralActivityId, totalPrizeNum);

        sweetRedisAdminUtils.setIntegralActivityInfo(integralActivityVo);
    }

}
