create database if not exists ln_scene character set utf8mb4 collate utf8mb4_unicode_ci;
-- >>------------------------------------------------------------------------------------
use ln_scene;

-- 舞台表
drop TABLE if exists `sweet_stage`;
CREATE TABLE `sweet_stage`
(
    `mid`        bigint unsigned NOT NULL AUTO_INCREMENT,
    `stage_id`   varchar(200)    NOT NULL DEFAULT '' COMMENT 'stage_id',
    `title`      varchar(200)    NOT NULL DEFAULT '' COMMENT '舞台名称',
    `status`     tinyint         NOT NULL DEFAULT 1 COMMENT '状态 1可用 0不可用',
    `created_at` datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at` datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `stage_id_index` (`stage_id`),
    KEY `title_index` (`title`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '舞台表';

-- 艺人表
drop TABLE if exists `sweet_artists`;
CREATE TABLE `sweet_artists`
(
    `mid`        bigint unsigned                                         NOT NULL AUTO_INCREMENT,
    `artists_id` varchar(200)                                            NOT NULL COMMENT 'artists_id',
    `pic_url`    varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '图片地址',
    `name`       varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '艺人名称',
    `pinyin`     varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '拼音',
    `describes`  text CHARACTER SET utf8 COLLATE utf8_unicode_ci         NOT NULL COMMENT '艺人简介',
    `status`     tinyint                                                 NOT NULL DEFAULT 1 COMMENT '状态 1可用 0不可用',
    `created_at` datetime                                                NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updatd_at`  datetime                                                NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `artists_id_index` (`artists_id`),
    KEY `name_index` (`name`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '艺人表';

-- 电子宣传手册表
drop TABLE if exists `sweet_manual`;
CREATE TABLE `sweet_manual`
(
    `mid`            bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_id`      varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_id',
    `performance_id` varchar(200)    NULL COMMENT '演出id',
    `status`         tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `is_release`     tinyint         NOT NULL DEFAULT 1 COMMENT '0取消 1发布',
    `created_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),

    KEY `manual_id_index` (`manual_id`),
    KEY `performance_id_index` (`performance_id`),
    KEY `is_release_index` (`is_release`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册表';

-- 电子宣传手册显示内容表
drop TABLE if exists `sweet_manual_sort`;
CREATE TABLE `sweet_manual_sort`
(
    `mid`           bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_id`     varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_id',
    `show_position` varchar(200)    NULL COMMENT '显示哪个，号隔开',
    `created_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `manual_id_index` (`manual_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册显示内容表';

-- 电子宣传手册富文本表
drop TABLE if exists `sweet_richtext`;
CREATE TABLE `sweet_richtext`
(
    `mid`         bigint unsigned NOT NULL AUTO_INCREMENT,
    `richtext_id` varchar(200)    NOT NULL DEFAULT '0' COMMENT 'order_refund_id',
    `manual_id`   varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_id',
    `details`     longtext        NULL COMMENT '富文本详情',
    `local`       varchar(200)    NOT NULL DEFAULT '' COMMENT '经纬度 5需要',
    `pic_url`     varchar(200)    NOT NULL DEFAULT '' COMMENT '地图图片地址 2需要',
    `type`        tinyint         NOT NULL DEFAULT 0 COMMENT '类型 1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略',
    `status`      tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`  datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`  datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),

    KEY `richtext_id_index` (`richtext_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `type_index` (`type`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册富文本表';


-- 电子宣传手册艺人表
drop TABLE if exists `sweet_manual_artists`;
CREATE TABLE `sweet_manual_artists`
(
    `mid`                bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_relation_id` varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_relation_id',
    `manual_id`          varchar(200)    NOT NULL DEFAULT '' COMMENT '电子宣传手册id',
    `stage_id`           varchar(200)    NULL COMMENT '关联id',
    `artists_id`         varchar(200)    NULL COMMENT '关联id',
    `performance_start`  datetime        NULL COMMENT '演出开始时间',
    `performance_end`    datetime        NULL COMMENT '演出结束时间',
    `signature_start`    datetime        NULL COMMENT '签收开始时间',
    `signature_end`      datetime        NULL COMMENT '签收结束时间',
    `status`             tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),

    KEY `manual_relation_id_index` (`manual_relation_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `stage_id_index` (`stage_id`),
    KEY `artists_id_index` (`artists_id`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册艺人表';


-- 电子宣传手册通知表
drop TABLE if exists `sweet_manual_notify`;
CREATE TABLE `sweet_manual_notify`
(
    `mid`              bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_notify_id` varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_notify_id',
    `manual_id`          varchar(200)    NOT NULL DEFAULT '' COMMENT '电子宣传手册id',
    `title`            varchar(200)    NOT NULL DEFAULT '' COMMENT '标题',
    `content`          longtext        NULL COMMENT '内容',
    `status`           tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`       datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`       datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `manual_notify_id_index` (`manual_notify_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册通知表';


-- 电子宣传手册商铺表
drop TABLE if exists `sweet_manual_shop`;
CREATE TABLE `sweet_manual_shop`
(
    `mid`                   bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_shop_id`        varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_shop_id',
    `manual_id`             varchar(200)    NOT NULL DEFAULT '' COMMENT '电子宣传手册id',
    `title`                 varchar(200)    NOT NULL DEFAULT '' COMMENT '商家名称',
    `pic_url`               varchar(200)    NOT NULL DEFAULT '' COMMENT '商家图片',
    `describes`              longtext        NULL COMMENT '商家介绍',
    `type`                  tinyint         NOT NULL DEFAULT 1 COMMENT '1吃喝 2玩乐',
    `is_recommend`          tinyint         NOT NULL DEFAULT 1 COMMENT '0不推荐 1推荐',
    `sort`                  tinyint         NOT NULL DEFAULT 0 COMMENT '排序字段 数字越大越靠前',
    `status`                tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`            datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`            datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `manual_shop_index` (`manual_shop_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册商铺表';

-- 正在现场服务号关注事件储存用户信息表
drop TABLE if exists `sweet_wechat_user`;
CREATE TABLE `sweet_wechat_user`
(
    `mid`            bigint unsigned NOT NULL AUTO_INCREMENT,
    `user_id`        varchar(200)    NOT NULL DEFAULT '' COMMENT 'user_id',
    `openId`         varchar(200)    NOT NULL DEFAULT '' COMMENT 'openId',
    `unionId`        varchar(200)    NOT NULL DEFAULT '' COMMENT 'unionId',
    `nickname`       varchar(200)    NOT NULL DEFAULT '' COMMENT '昵称',
    `sexDesc`        varchar(200)    NOT NULL DEFAULT '' COMMENT '性别',
    `sex`            tinyint         NOT NULL DEFAULT 0 COMMENT '性别 男1',
    `headImgUrl`     varchar(200)    NOT NULL DEFAULT '' COMMENT '头像',
    `language`       varchar(200)    NOT NULL DEFAULT '' COMMENT 'zh_CN',
    `country`        varchar(200)    NOT NULL DEFAULT '' COMMENT '国家',
    `province`       varchar(200)    NOT NULL DEFAULT '' COMMENT '省',
    `city`           varchar(200)    NOT NULL DEFAULT '' COMMENT '市',
    `subscribeTime`  datetime        NULL     DEFAULT null COMMENT '关注时间',
    `subscribeScene` varchar(200)    NOT NULL DEFAULT '' COMMENT 'ADD_SCENE_SEARCH 关注方式',
    `created_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_wechat_user_user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '正在现场服务号关注事件储存用户信息表';


-- 用户 收藏/喜欢等状态
drop TABLE if exists `sweet_user_relation`;
CREATE TABLE `sweet_user_relation`
(
    `mid`               bigint unsigned NOT NULL AUTO_INCREMENT,
    `user_id`           varchar(200)    NOT NULL DEFAULT '' COMMENT '用户id',
    `type`             tinyint    NOT NULL DEFAULT 0 COMMENT '类型 1喜欢艺人  2签售艺人',
    `target_id`         varchar(200)    NOT NULL DEFAULT '' COMMENT '目标id',
    `manual_id`            varchar(200)    NOT NULL DEFAULT '' COMMENT '电子手册',
    `status`            tinyint    NOT NULL DEFAULT 0 COMMENT '1是 0否',
    `created_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_wechat_user_user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '用户 收藏/喜欢等状态';


--    下面为MDSK表     --
-- 电子宣传手册表
drop TABLE if exists `sweet_manual_mdsk`;
CREATE TABLE `sweet_manual_mdsk`
(
    `mid`            bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_id`      varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_id',
    `performance_id` varchar(200)    NULL COMMENT '演出id',
    `status`         tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `is_release`     tinyint         NOT NULL DEFAULT 1 COMMENT '0取消 1发布',
    `created_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),

    KEY `manual_id_index` (`manual_id`),
    KEY `performance_id_index` (`performance_id`),
    KEY `is_release_index` (`is_release`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册表';

-- 电子宣传手册显示内容表
drop TABLE if exists `sweet_manual_sort_mdsk`;
CREATE TABLE `sweet_manual_sort_mdsk`
(
    `mid`           bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_id`     varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_id',
    `show_position` varchar(200)    NULL COMMENT '显示哪个，号隔开',
    `created_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `manual_id_index` (`manual_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册显示内容表';

-- 电子宣传手册富文本表
drop TABLE if exists `sweet_richtext_mdsk`;
CREATE TABLE `sweet_richtext_mdsk`
(
    `mid`         bigint unsigned NOT NULL AUTO_INCREMENT,
    `richtext_id` varchar(200)    NOT NULL DEFAULT '0' COMMENT 'order_refund_id',
    `manual_id`   varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_id',
    `details`     longtext        NULL COMMENT '富文本详情',
    `local`       varchar(200)    NOT NULL DEFAULT '' COMMENT '经纬度 5需要',
    `pic_url`     varchar(200)    NOT NULL DEFAULT '' COMMENT '地图图片地址 2需要',
    `type`        tinyint         NOT NULL DEFAULT 0 COMMENT '类型 1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略',
    `status`      tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`  datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`  datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),

    KEY `richtext_id_index` (`richtext_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `type_index` (`type`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册富文本表';


-- 电子宣传手册艺人表
drop TABLE if exists `sweet_manual_artists_mdsk`;
CREATE TABLE `sweet_manual_artists_mdsk`
(
    `mid`                bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_relation_id` varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_relation_id',
    `manual_id`          varchar(200)    NOT NULL DEFAULT '' COMMENT '电子宣传手册id',
    `stage_id`           varchar(200)    NULL COMMENT '关联id',
    `artists_id`         varchar(200)    NULL COMMENT '关联id',
    `performance_start`  datetime        NULL COMMENT '演出开始时间',
    `performance_end`    datetime        NULL COMMENT '演出结束时间',
    `signature_start`    datetime        NULL COMMENT '签收开始时间',
    `signature_end`      datetime        NULL COMMENT '签收结束时间',
    `status`             tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),

    KEY `manual_relation_id_index` (`manual_relation_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `stage_id_index` (`stage_id`),
    KEY `artists_id_index` (`artists_id`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册艺人表';


-- 电子宣传手册通知表
drop TABLE if exists `sweet_manual_notify_mdsk`;
CREATE TABLE `sweet_manual_notify_mdsk`
(
    `mid`              bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_notify_id` varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_notify_id',
    `manual_id`          varchar(200)    NOT NULL DEFAULT '' COMMENT '电子宣传手册id',
    `title`            varchar(200)    NOT NULL DEFAULT '' COMMENT '标题',
    `content`          longtext        NULL COMMENT '内容',
    `status`           tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`       datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`       datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `manual_notify_id_index` (`manual_notify_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册通知表';


-- 电子宣传手册商铺表
drop TABLE if exists `sweet_manual_shop_mdsk`;
CREATE TABLE `sweet_manual_shop_mdsk`
(
    `mid`                   bigint unsigned NOT NULL AUTO_INCREMENT,
    `manual_shop_id`        varchar(200)    NOT NULL DEFAULT '0' COMMENT 'manual_shop_id',
    `manual_id`             varchar(200)    NOT NULL DEFAULT '' COMMENT '电子宣传手册id',
    `title`                 varchar(200)    NOT NULL DEFAULT '' COMMENT '商家名称',
    `pic_url`               varchar(200)    NOT NULL DEFAULT '' COMMENT '商家图片',
    `describes`              longtext        NULL COMMENT '商家介绍',
    `type`                  tinyint         NOT NULL DEFAULT 1 COMMENT '1吃喝 2玩乐',
    `is_recommend`          tinyint         NOT NULL DEFAULT 1 COMMENT '0不推荐 1推荐',
    `sort`                  tinyint         NOT NULL DEFAULT 0 COMMENT '排序字段 数字越大越靠前',
    `status`                tinyint         NOT NULL DEFAULT 1 COMMENT '0关闭 1开启',
    `created_at`            datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`            datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `manual_shop_index` (`manual_shop_id`),
    KEY `manual_id_index` (`manual_id`),
    KEY `status_index` (`status`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '电子宣传手册商铺表';

-- 正在现场服务号关注事件储存用户信息表
drop TABLE if exists `sweet_wechat_user_mdsk`;
CREATE TABLE `sweet_wechat_user_mdsk`
(
    `mid`            bigint unsigned NOT NULL AUTO_INCREMENT,
    `user_id`        varchar(200)    NOT NULL DEFAULT '' COMMENT 'user_id',
    `openId`         varchar(200)    NOT NULL DEFAULT '' COMMENT 'openId',
    `unionId`        varchar(200)    NOT NULL DEFAULT '' COMMENT 'unionId',
    `nickname`       varchar(200)    NOT NULL DEFAULT '' COMMENT '昵称',
    `sexDesc`        varchar(200)    NOT NULL DEFAULT '' COMMENT '性别',
    `sex`            tinyint         NOT NULL DEFAULT 0 COMMENT '性别 男1',
    `headImgUrl`     varchar(200)    NOT NULL DEFAULT '' COMMENT '头像',
    `language`       varchar(200)    NOT NULL DEFAULT '' COMMENT 'zh_CN',
    `country`        varchar(200)    NOT NULL DEFAULT '' COMMENT '国家',
    `province`       varchar(200)    NOT NULL DEFAULT '' COMMENT '省',
    `city`           varchar(200)    NOT NULL DEFAULT '' COMMENT '市',
    `subscribeTime`  datetime        NULL     DEFAULT null COMMENT '关注时间',
    `subscribeScene` varchar(200)    NOT NULL DEFAULT '' COMMENT 'ADD_SCENE_SEARCH 关注方式',
    `created_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_wechat_user_user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '正在现场服务号关注事件储存用户信息表';


-- 用户 收藏/喜欢等状态
drop TABLE if exists `sweet_user_relation_mdsk`;
CREATE TABLE `sweet_user_relation_mdsk`
(
    `mid`               bigint unsigned NOT NULL AUTO_INCREMENT,
    `user_id`           varchar(200)    NOT NULL DEFAULT '' COMMENT '用户id',
    `type`             tinyint    NOT NULL DEFAULT 0 COMMENT '类型 1喜欢艺人  2签售艺人',
    `target_id`         varchar(200)    NOT NULL DEFAULT '' COMMENT '目标id',
    `manual_id`            varchar(200)    NOT NULL DEFAULT '' COMMENT '电子手册',
    `status`            tinyint    NOT NULL DEFAULT 0 COMMENT '1是 0否',
    `created_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_wechat_user_user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '用户 收藏/喜欢等状态';


-- 抽奖表
drop TABLE if exists `sweet_luck_draw`;
CREATE TABLE `sweet_luck_draw`
(
    `mid`               bigint unsigned NOT NULL AUTO_INCREMENT,
    `user_id`           varchar(200)    NOT NULL DEFAULT '' COMMENT '用户id',
    `luck_draw_num`     varchar(200)    NOT NULL DEFAULT '' COMMENT '抽奖编号',
    `status`            tinyint    NOT NULL DEFAULT 1 COMMENT '1有资格 0无资格',
    `created_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`     datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_wechat_user_user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '抽奖表';

-- 答题表
drop TABLE if exists `sweet_answer`;
CREATE TABLE `sweet_answer`
(
    `mid`         bigint unsigned NOT NULL AUTO_INCREMENT,
    `answer_id`   varchar(200)    NOT NULL DEFAULT '' COMMENT 'answer_id',
    `phone`       varchar(11)     NOT NULL DEFAULT '' COMMENT '手机号',
    `answer_json` varchar(255)    NOT NULL DEFAULT '' COMMENT '答案json',
    `img_url`     varchar(255)    NOT NULL DEFAULT '' COMMENT '图片',
    `created_at`  datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`  datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_answer_answer_id` (`answer_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '答题表';

