package com.liquidnet.service.feign.bank.api.currencycloud;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcBeneficiaryParam;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBeneficiary;
import com.liquidnet.service.feign.bank.api.constant.FeignBankConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Service
@FeignClient(name = FeignBankConstant.LIQUIDNET_SERVICE_BANK,
        path = FeignBankConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignBankConstant.CONTEXT_BANK_CC_BENEFICIARY)
public interface FeignBankCcBeneficiaryClient {

    @RequestMapping(value = "/bank-cc-beneficiary/create", method = RequestMethod.POST)
    ResponseDto<BankCcBeneficiaryParam> create(@RequestBody BankCcBeneficiaryParam param);

    @RequestMapping(value = "/bank-cc-beneficiary/required_details", method = RequestMethod.GET)
    ResponseDto<List<Map<String, String>>> requiredDetails(
            @RequestParam("currency") String currency,
            @RequestParam("bankAccountCountry") String bankAccountCountry,
            @RequestParam("beneficiaryCountry") String beneficiaryCountry);

}
