package com.liquidnet.client.admin.zhengzai.goblin.service.imp;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontBannerService;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.common.cache.redis.util.RedisGoblinUtil;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import com.liquidnet.service.goblin.mapper.GoblinFrontBannerMapper;
import com.liquidnet.service.kylin.dao.BannerDetailsListDao;
import com.liquidnet.service.kylin.dto.param.BannersSearchParam;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.mongodb.BasicDBObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.VariableOperators;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Service
public class GoblinFrontBannerServiceImpl extends ServiceImpl<GoblinFrontBannerMapper, GoblinFrontBanner> implements IGoblinFrontBannerService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontBannerMapper goblinFrontBannerMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(GoblinFrontBanner goblinFrontBanner){
        //设置bannerid
        goblinFrontBanner.setBannerId(GoblinRedisConst.FRONT_BANNER+ IDGenerator.nextTimeId());
        //增加 banner
        goblinFrontBannerMapper.insert(goblinFrontBanner);
        //mongo  db增加
        mongoTemplate.save(goblinFrontBanner,GoblinFrontBanner.class.getSimpleName());
        //redis 增加
        if(redisDataSourceUtil.getRedisGoblinUtil().hasKey(GoblinRedisConst.FRONT_BANNER)){
            //从redis里面取出
            ArrayList<GoblinFrontBanner> list = (ArrayList<GoblinFrontBanner>) redisDataSourceUtil.getRedisGoblinUtil().get(GoblinRedisConst.FRONT_BANNER);
            list.add(goblinFrontBanner);
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER,list);
        }else{
            //创建一个list
            ArrayList<Object> list= CollectionUtil.arrayListObject();
            list.add(goblinFrontBanner);
            //redis 没有这个键
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER,list);
        }
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改
     * @date 2021/12/27 下午4:03
     */
    public boolean update(GoblinFrontBanner goblinFrontBanner){
        //数据库修改
        goblinFrontBannerMapper.updateById(goblinFrontBanner);
        //mongodb修改
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontBanner)));
        mongoTemplate.getCollection(GoblinFrontBanner.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("bannerId").is(goblinFrontBanner.getBannerId())).getQueryObject(),
                orderObject
        );
        //redis 修改
        if(redisDataSourceUtil.getRedisGoblinUtil().hasKey(GoblinRedisConst.FRONT_BANNER+"0")){
            ArrayList<GoblinFrontBanner> list = (ArrayList<GoblinFrontBanner>) redisDataSourceUtil.getRedisGoblinUtil().get(GoblinRedisConst.FRONT_BANNER+0);
            list= (ArrayList<GoblinFrontBanner>) list.stream().map(goblinFrontBanner1->{
                if(goblinFrontBanner1.getBannerId().equals(goblinFrontBanner.getBannerId())){
                    return goblinFrontBanner;
                }
                return goblinFrontBanner1;
            }).collect(Collectors.toList());
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER+"0",list);
        }
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:查看详情
     * @date 2021/12/27 下午4:34
     */
    public GoblinFrontBanner getOne(Long id){
        return  goblinFrontBannerMapper.selectById(id);
    }
    /**
     * @author zhangfuxin
     * @Description:  删除 banner
     * @date 2021/12/27 下午4:36
     */
    public boolean delte(Long id){
        //数据库
        goblinFrontBannerMapper.deleteById(id);
        //mongodb 删除
        mongoTemplate.remove(Query.query(Criteria.where("mid").is(id)), GoblinFrontBanner.class, GoblinFrontBanner.class.getSimpleName());
        //redis 删除
        if(redisDataSourceUtil.getRedisGoblinUtil().hasKey(GoblinRedisConst.FRONT_BANNER+"0")){
            ArrayList<GoblinFrontBanner> list = (ArrayList<GoblinFrontBanner>) redisDataSourceUtil.getRedisGoblinUtil().get(GoblinRedisConst.FRONT_BANNER+0);
            list= (ArrayList<GoblinFrontBanner>) list.stream().map(goblinFrontBanner1->{
                if(goblinFrontBanner1.getMid().equals(id)){
                    return null;
                }
                return goblinFrontBanner1;
            }).collect(Collectors.toList());
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_BANNER+"0",list);
        }
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:分页
     * @date 2021/12/27 下午5:19
     */
    public PageInfo<GoblinFrontBanner> bannerPage(int pageSize,int pageNumber,GoblinFrontBanner goblinFrontBanner) {
        PageInfo<GoblinFrontBanner> pageInfoTmp = null;
        try {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontBanner> queryWrapper = Wrappers.lambdaQuery(GoblinFrontBanner.class);
            queryWrapper.orderByDesc(GoblinFrontBanner::getCreateTime);
            List<GoblinFrontBanner> list=goblinFrontBannerMapper.selectList(queryWrapper);
            pageInfoTmp = new PageInfo(list);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }


}
