package com.liquidnet.client.admin.zhengzai.goblin.service.imp;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontNavigationService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import com.liquidnet.service.goblin.entity.GoblinFrontNavigation;
import com.liquidnet.service.goblin.mapper.GoblinFrontBannerMapper;
import com.liquidnet.service.goblin.mapper.GoblinFrontNavigationMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

/**
 * <p>
 * 首页导航栏
 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Service
public class GoblinFrontNavigationServiceImpl extends ServiceImpl<GoblinFrontNavigationMapper, GoblinFrontNavigation> implements IGoblinFrontNavigationService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontNavigationMapper goblinFrontNavigationMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(GoblinFrontNavigation goblinFrontNavigation){
        //设置金刚位id
        goblinFrontNavigation.setNavigationId(GoblinRedisConst.FRONT_NAVIGATION+ IDGenerator.nextTimeId());
        //mysql插入
        goblinFrontNavigationMapper.insert(goblinFrontNavigation);
        //mongo  db增加
        mongoTemplate.save(goblinFrontNavigation,GoblinFrontNavigation.class.getSimpleName());
        //redis增加
        if(redisDataSourceUtil.getRedisGoblinUtil().hasKey(GoblinRedisConst.FRONT_NAVIGATION)){
            //从redis里面取出
            ArrayList<GoblinFrontNavigation> list = (ArrayList<GoblinFrontNavigation>) redisDataSourceUtil.getRedisGoblinUtil().get(GoblinRedisConst.FRONT_BANNER);
            list.add(goblinFrontNavigation);
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_NAVIGATION,list);
        }else{
            //创建一个list
            ArrayList<Object> list= CollectionUtil.arrayListObject();
            list.add(goblinFrontNavigation);
            //redis 没有这个键
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_NAVIGATION,list);
        }
        return  true;
    }
    public boolean update(GoblinFrontNavigation goblinFrontBanner){
        return true;
    }
    public GoblinFrontNavigation getOne(Long id){
        return null;
    }
    public boolean delte(Long id){
        return true;
    }
    public PageInfo<GoblinFrontNavigation> page(int pageSize, int pageNumber, GoblinFrontNavigation goblinFrontNavigation) {
        return null;
    }
}
