package com.liquidnet.client.admin.zhengzai.goblin.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.entity.GoblinSelfMarketing;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoblinRedisUtils {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    /**
     * 覆盖官方活动
     *
     * @param selfMarketId
     * @param data
     */
    public void setSelfMarket(String selfMarketId, GoblinSelfMarketingVo data) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, data);
    }
}
